/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filesystem.FileSystemAccess;
import org.eclipse.core.internal.filesystem.Messages;
import org.eclipse.core.internal.filesystem.Policy;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class FileCache {
    private static final String CACHE_DIR_NAME = "filecache";
    static final boolean MACOSX = FileCache.getOS().equals("macosx");
    private final File cacheDir;

    public static FileCache getCache() throws CoreException {
        FileCache instance = FileCacheHolder.instance;
        if (instance == null) {
            throw FileCacheHolder.ce;
        }
        return instance;
    }

    FileCache() throws CoreException {
        IPath location = FileSystemAccess.getCacheLocation();
        File cacheParent = new File(location.toFile(), CACHE_DIR_NAME);
        this.cleanOldCache(cacheParent);
        cacheParent.mkdirs();
        this.cacheDir = this.getUniqueDirectory(cacheParent, true);
    }

    public File cache(IFileStore source, IProgressMonitor monitor) throws CoreException {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.copying, (Object)this.toString()), (int)3);
            IFileInfo myInfo = source.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(1));
            if (!myInfo.exists()) {
                return new File(this.cacheDir, "Non-Existent-" + System.currentTimeMillis());
            }
            File result = myInfo.isDirectory() ? this.getUniqueDirectory(this.cacheDir, false) : File.createTempFile(source.getFileSystem().getScheme(), "efs", this.cacheDir);
            subMonitor.worked(1);
            LocalFile resultStore = new LocalFile(result);
            source.copy(resultStore, 2, (IProgressMonitor)subMonitor.newChild(1));
            result.deleteOnExit();
            return result;
        }
        catch (IOException e) {
            Policy.error(272, NLS.bind((String)Messages.couldNotWrite, (Object)this.toString()));
            return null;
        }
    }

    private void cleanOldCache(File cacheParent) throws CoreException {
        if (MACOSX) {
            this.clearImmutableFlag(cacheParent);
        }
        new LocalFile(cacheParent).delete(0, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void clearImmutableFlag(File target) {
        if (!target.exists()) {
            return;
        }
        if (target.isDirectory()) {
            File[] children = target.listFiles();
            if (children == null) return;
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File element = fileArray[n2];
                this.clearImmutableFlag(element);
                ++n2;
            }
            return;
        } else {
            LocalFile lfile = new LocalFile(target);
            try {
                IFileInfo info = lfile.fetchInfo(0, null);
                if (!info.getAttribute(0x200000)) return;
                info.setAttribute(0x200000, false);
                lfile.putInfo(info, 1024, null);
                return;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    static String getOS() {
        return System.getProperty("osgi.os", "");
    }

    private File getUniqueDirectory(File parent, boolean create) {
        File dir;
        long i = 0L;
        while ((dir = new File(parent, Long.toString(System.currentTimeMillis() + i++))).exists()) {
        }
        if (create) {
            dir.mkdir();
        }
        return dir;
    }

    private static class FileCacheHolder {
        static final FileCache instance = FileCacheHolder.createFileCache();
        static CoreException ce;

        private FileCacheHolder() {
        }

        private static FileCache createFileCache() {
            try {
                return new FileCache();
            }
            catch (CoreException e) {
                ce = e;
                return null;
            }
        }
    }
}

