/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.ui;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PropertyNodeType implements Enumerator
{
    PROPERTY(0, "Property", "Property"),
    REFERENCE(1, "Reference", "Reference");

    public static final int PROPERTY_VALUE = 0;
    public static final int REFERENCE_VALUE = 1;
    private static final PropertyNodeType[] VALUES_ARRAY;
    public static final List<PropertyNodeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PropertyNodeType[]{PROPERTY, REFERENCE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PropertyNodeType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PropertyNodeType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PropertyNodeType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PropertyNodeType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PropertyNodeType get(int value) {
        switch (value) {
            case 0: {
                return PROPERTY;
            }
            case 1: {
                return REFERENCE;
            }
        }
        return null;
    }

    private PropertyNodeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

