/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.model.search;

import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.search.IIndexRequestor;
import org.eclipse.rcptt.core.model.search.ISearchPattern;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.model.index.Index;
import org.eclipse.rcptt.internal.core.model.index.QueryResult;

public class IDSearchPattern
implements ISearchPattern {
    private String id;

    public IDSearchPattern(String id) {
        this.id = id;
    }

    @Override
    public void findIndexMatches(Index index, IProgressMonitor monitor, IIndexRequestor requestor) {
        List<QueryResult> results = index.queryIDs(this.id);
        IPath path = index.getPath();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        for (QueryResult queryResult : results) {
            Path fullPath = new Path(queryResult.path);
            IQ7Element q7Element = RcpttCore.create(root.findMember(path.append((IPath)fullPath)));
            requestor.acceptMatch(q7Element, queryResult.key, queryResult.value);
        }
    }
}

