/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.persistence.plain;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class SeparatorReader
extends Reader {
    private static final boolean DEBUG = false;
    private final Separator terminator;
    private final Reader reader;
    private final StringBuilder tail = new StringBuilder();
    private char[] tempBuffer = new char[5];
    private boolean done = false;
    private final int term_length;

    public SeparatorReader(Reader reader, Separator separator) {
        this.terminator = Objects.requireNonNull(separator);
        this.term_length = this.terminator.length();
        if (this.term_length <= 0) {
            throw new IllegalArgumentException("Delimiter can't be empty");
        }
        this.reader = reader;
        if (!reader.markSupported()) {
            throw new IllegalArgumentException("mark() support is required");
        }
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        Optional<Match> position;
        do {
            if (this.done) {
                return this.consumeTail(cbuf, off, len);
            }
            if (this.tail.length() > this.term_length) {
                len = Math.min(len, this.tail.length() - this.terminator.length());
                return this.consumeTail(cbuf, off, len);
            }
            if (this.tempBuffer.length < len) {
                this.tempBuffer = new char[len];
            }
            this.reader.mark(this.tempBuffer.length + 1);
            int result = this.reader.read(this.tempBuffer, 0, this.tempBuffer.length);
            if (result < 0) {
                this.done = true;
                return this.consumeTail(cbuf, off, len);
            }
            position = this.terminator.accept(this.tempBuffer, result);
            if (position.isPresent()) {
                this.done = true;
                result = Math.min(position.get().start, result);
            }
            assert (this.tail.length() + result >= 0);
            assert (result > -this.terminator.length());
            if (result > 0) {
                this.tail.append(this.tempBuffer, 0, result);
                continue;
            }
            if (result >= 0) continue;
            this.tail.delete(this.tail.length() + result, this.tail.length());
        } while (!this.done);
        this.reader.reset();
        long read = this.reader.skip(position.get().end);
        assert (read == (long)position.get().end);
        return this.consumeTail(cbuf, off, len);
    }

    private int consumeTail(char[] cbuf, int off, int len) {
        assert (len > 0);
        if (this.tail.length() == 0) {
            return -1;
        }
        len = Math.min(this.tail.length(), len);
        this.tail.getChars(0, len, cbuf, off);
        this.tail.delete(0, len);
        return len;
    }

    @Override
    public final void close() throws IOException {
    }

    public static final class Match {
        public final int start;
        public final int end;

        public Match(int start, int end) {
            this.start = start;
            this.end = end;
            if (start >= end) {
                throw new IllegalArgumentException(start + " >= " + end);
            }
        }
    }

    static interface Separator {
        public Optional<Match> accept(char[] var1, int var2);

        public int length();

        public static final class Any
        implements Separator {
            private final Separator[] delegates;

            public Any(Separator ... delegates) {
                this.delegates = Arrays.copyOf(delegates, delegates.length);
                if (this.delegates.length == 0) {
                    throw new IllegalArgumentException("Can't be empty");
                }
                if (Arrays.stream(this.delegates).anyMatch(Objects::isNull)) {
                    throw new NullPointerException();
                }
            }

            @Override
            public Optional<Match> accept(char[] input, int len) {
                return Arrays.stream(this.delegates).map(d -> d.accept(input, len)).flatMap(m -> m.map(Stream::of).orElse(Stream.empty())).min(Comparator.comparingInt(m -> m.start));
            }

            @Override
            public int length() {
                return Arrays.stream(this.delegates).mapToInt(Separator::length).max().orElseThrow(() -> new AssertionError());
            }
        }

        public static final class Exact
        implements Separator {
            private final char[] separator;
            private int position = 0;

            public Exact(String string) {
                this.separator = string.toCharArray();
                if (string.isEmpty()) {
                    throw new IllegalArgumentException("Separator can't be empty");
                }
            }

            @Override
            public Optional<Match> accept(char[] input, int len) {
                if (this.position >= this.separator.length) {
                    throw new IllegalStateException("Can't operate in COMPLETE state");
                }
                int i = 0;
                while (i < len) {
                    if (input[i] == this.separator[this.position]) {
                        ++this.position;
                        if (this.position >= this.separator.length) {
                            return Optional.of(new Match(i - this.position + 1, i + 1));
                        }
                    } else {
                        this.position = input[i] == this.separator[0] ? 1 : 0;
                    }
                    ++i;
                }
                return Optional.empty();
            }

            @Override
            public int length() {
                return this.separator.length;
            }
        }
    }
}

