/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.core.ContextType;
import org.eclipse.rcptt.core.VerificationType;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7Folder;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.IQ7ProjectMetadata;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ITestSuite;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.persistence.PersistenceManager;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.core.scenario.ProjectMetadata;
import org.eclipse.rcptt.core.scenario.Scenario;
import org.eclipse.rcptt.core.scenario.ScenarioFactory;
import org.eclipse.rcptt.core.scenario.TestSuite;
import org.eclipse.rcptt.core.scenario.Verification;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.Q7LazyResource;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.core.model.Openable;
import org.eclipse.rcptt.internal.core.model.OpenableElementInfo;
import org.eclipse.rcptt.internal.core.model.Q7Context;
import org.eclipse.rcptt.internal.core.model.Q7Element;
import org.eclipse.rcptt.internal.core.model.Q7FolderInfo;
import org.eclipse.rcptt.internal.core.model.Q7ProjectMetadata;
import org.eclipse.rcptt.internal.core.model.Q7TestCase;
import org.eclipse.rcptt.internal.core.model.Q7TestSuite;
import org.eclipse.rcptt.internal.core.model.Q7Verification;
import org.eclipse.rcptt.internal.core.model.Util;

public class Q7Folder
extends Openable
implements IQ7Folder {
    private final IPath path;

    protected Q7Folder(Q7Element parent, IPath path) throws IllegalArgumentException {
        super(parent);
        if (parent == null) {
            throw new NullPointerException();
        }
        this.path = path;
    }

    @Override
    public IQ7Element.HandleType getElementType() {
        return IQ7Element.HandleType.Folder;
    }

    @Override
    public boolean isRootFolder() {
        return this.path.segmentCount() == 0;
    }

    @Override
    public IResource getResource() {
        if (this.isRootFolder()) {
            return this.getParent().getResource();
        }
        return ((IContainer)this.getParent().getResource()).getFolder(this.path);
    }

    @Override
    public String getName() {
        if (this.path.segmentCount() == 0) {
            return "";
        }
        return this.path.lastSegment();
    }

    @Override
    public IPath getPath() {
        return this.getParent().getPath().append(this.path);
    }

    @Override
    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, IResource underlyingResource) throws ModelException {
        if (!underlyingResource.isAccessible()) {
            throw this.newNotPresentException();
        }
        HashSet<IQ7NamedElement> vChildren = new HashSet<IQ7NamedElement>();
        try {
            IResource[] members = ((IContainer)underlyingResource).members();
            int i = 0;
            int max = members.length;
            while (i < max) {
                IPath childPath;
                IResource child = members[i];
                if (child.getType() != 2 && RcpttCore.isQ7File(childPath = child.getFullPath())) {
                    if (RcpttCore.isQ7Context(childPath)) {
                        vChildren.add(this.getContext(child.getName()));
                    } else if (RcpttCore.isQ7Verification(childPath)) {
                        vChildren.add(this.getVerification(child.getName()));
                    } else if (RcpttCore.isQ7TestSuite(childPath)) {
                        vChildren.add(this.getTestSuite(child.getName()));
                    } else if (RcpttCore.isQ7ProjectMetadata(childPath)) {
                        vChildren.add(this.getMetadata());
                    } else {
                        vChildren.add(this.getTestCase(child.getName()));
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
        info.setChildren(vChildren.toArray(new IQ7Element[vChildren.size()]));
        return true;
    }

    @Override
    public ITestCase getTestCase(String name) {
        return new Q7TestCase(this, name);
    }

    @Override
    public IContext getContext(String name) {
        return new Q7Context(this, name);
    }

    @Override
    public ITestCase[] getTestCases() throws ModelException, InterruptedException {
        List<IQ7Element> list = this.getChildrenOfType(IQ7Element.HandleType.TestCase);
        return list.toArray(new ITestCase[list.size()]);
    }

    @Override
    public IContext[] getContexts() throws ModelException, InterruptedException {
        List<IQ7Element> list = this.getChildrenOfType(IQ7Element.HandleType.Context);
        return list.toArray(new IContext[list.size()]);
    }

    @Override
    public Object[] getForeignResources() throws ModelException, InterruptedException {
        return this.accessFolderInfo(info -> info.getForeignResources(this.getResource()));
    }

    @Override
    public boolean hasSubfolders() throws ModelException, InterruptedException {
        IQ7Element[] packages = ((IQ7Project)this.getParent()).getChildren();
        int namesLength = this.path.segmentCount();
        int i = 0;
        int length = packages.length;
        while (i < length) {
            block4: {
                IPath otherNames = null;
                if (packages[i] instanceof Q7Folder && (otherNames = ((Q7Folder)packages[i]).path).segmentCount() > namesLength) {
                    int j = 0;
                    while (j < namesLength) {
                        if (this.path.segment(j).equals(otherNames.segment(j))) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean containsQ7Resources() throws ModelException, InterruptedException {
        return this.accessFolderInfo(Q7FolderInfo::containsQ7Resources);
    }

    public IFile getNewFile(IContainer container, String label, String extension) {
        String name = (label = Util.convert(label)) + "." + extension;
        if (Util.isValidName(container, name)) {
            return container.getFile((IPath)new Path(name));
        }
        int i = 1;
        while (!Util.isValidName(container, name = label + i + "." + extension)) {
            ++i;
        }
        return container.getFile((IPath)new Path(name));
    }

    @Override
    public ITestCase createTestCase(String name, boolean force, IProgressMonitor monitor) throws ModelException {
        IContainer parentContainer = (IContainer)this.getResource();
        IFile file = this.getNewFile(parentContainer, name, "test");
        Resource resource = this.createResource(file);
        Scenario scenario = this.createScenario(name);
        resource.getContents().add((Object)scenario);
        PersistenceManager.getInstance().saveResource(resource);
        return this.getTestCase(file.getName());
    }

    protected synchronized void createMetadata(boolean force, IProgressMonitor monitor) throws ModelException {
        IContainer parentContainer = (IContainer)this.getResource();
        IFile file = parentContainer.getFile((IPath)new Path("rcptt.properties"));
        try {
            file.refreshLocal(0, null);
        }
        catch (CoreException e) {
            return;
        }
        if (file.exists()) {
            return;
        }
        Resource resource = this.createResource(file);
        ProjectMetadata md = this.createMetadata();
        resource.getContents().add((Object)md);
        PersistenceManager.getInstance().saveResource(resource);
    }

    public ProjectMetadata createMetadata() {
        ProjectMetadata md = ScenarioFactory.eINSTANCE.createProjectMetadata();
        md.setName("Project Settings");
        md.setId(EcoreUtil.generateUUID());
        return md;
    }

    protected Scenario createScenario(String name) {
        Scenario scenario = ScenarioFactory.eINSTANCE.createScenario();
        scenario.setVersion(Double.toString(3.0));
        do {
            scenario.setId(EcoreUtil.generateUUID());
        } while (this.haveIDConflict(scenario.getId()));
        scenario.setName(name);
        return scenario;
    }

    protected TestSuite createTestSuite(String name) {
        TestSuite testSuite = ScenarioFactory.eINSTANCE.createTestSuite();
        do {
            testSuite.setId(EcoreUtil.generateUUID());
        } while (this.haveIDConflict(testSuite.getId()));
        testSuite.setName(name);
        return testSuite;
    }

    private Resource createResource(IFile file) {
        return new Q7LazyResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true));
    }

    @Override
    public IContext createContext(String name, ContextType type, boolean force, IProgressMonitor monitor) throws ModelException {
        IContainer parentContainer = (IContainer)this.getResource();
        IFile file = this.getNewFile(parentContainer, name, "ctx");
        Resource resource = this.createResource(file);
        this.createContext(name, type, resource);
        PersistenceManager.getInstance().saveResource(resource);
        return this.getContext(file.getName());
    }

    private void createContext(String name, ContextType type, Resource resource) {
        Context context = type.create(resource, name);
        do {
            context.setId(EcoreUtil.generateUUID());
        } while (this.haveIDConflict(context.getId()));
    }

    @Override
    public boolean haveIDConflict(String id) {
        try {
            IQ7NamedElement[] resources = this.getQ7Project().findNamedElement(id);
            if (resources.length == 0) {
                return false;
            }
        }
        catch (ModelException e) {
            RcpttPlugin.log((Throwable)((Object)e));
        }
        return true;
    }

    @Override
    protected Q7FolderInfo createElementInfo() {
        return new Q7FolderInfo();
    }

    @Override
    public IQ7NamedElement getNamedElement(String name) {
        IPath filePath = this.getPath().append(name);
        if (RcpttCore.isQ7File(filePath)) {
            if (RcpttCore.isQ7Context(filePath)) {
                return this.getContext(name);
            }
            if (RcpttCore.isQ7Verification(filePath)) {
                return this.getVerification(name);
            }
            if (RcpttCore.isQ7TestSuite(filePath)) {
                return this.getTestSuite(name);
            }
            if (RcpttCore.isQ7ProjectMetadata(filePath)) {
                return this.getMetadata();
            }
            return this.getTestCase(name);
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Q7Folder)) {
            return false;
        }
        Q7Folder other = (Q7Folder)o;
        return this.path.equals((Object)other.path) && this.parent.equals(other.parent);
    }

    @Override
    public int hashCode() {
        return Util.combineHashCodes(this.parent.hashCode(), this.path.toString().hashCode());
    }

    @Override
    protected void toStringName(StringBuffer buffer) {
        String elementName = this.getName();
        if (elementName.length() == 0) {
            buffer.append("<default>");
        } else {
            buffer.append(elementName);
        }
    }

    @Override
    public ITestSuite getTestSuite(String name) {
        return new Q7TestSuite(this, name);
    }

    public IQ7ProjectMetadata getMetadata() {
        return new Q7ProjectMetadata(this);
    }

    @Override
    public ITestSuite[] getTestSuites() throws ModelException, InterruptedException {
        List<IQ7Element> list = this.getChildrenOfType(IQ7Element.HandleType.TestSuite);
        return list.toArray(new ITestSuite[list.size()]);
    }

    @Override
    public ITestSuite createTestSuite(String name, boolean force, IProgressMonitor monitor) throws ModelException {
        IContainer parentContainer = (IContainer)this.getResource();
        IFile file = this.getNewFile(parentContainer, name, "suite");
        Resource resource = this.createResource(file);
        TestSuite testSuite = this.createTestSuite(name);
        resource.getContents().add((Object)testSuite);
        PersistenceManager.getInstance().saveResource(resource);
        return this.getTestSuite(file.getName());
    }

    @Override
    public IVerification createVerification(String name, VerificationType type, boolean force, IProgressMonitor monitor) throws ModelException {
        IContainer parentContainer = (IContainer)this.getResource();
        IFile file = this.getNewFile(parentContainer, name, "verification");
        Resource resource = this.createResource(file);
        this.createVerification(name, type, resource);
        PersistenceManager.getInstance().saveResource(resource);
        return this.getVerification(file.getName());
    }

    private void createVerification(String name, VerificationType type, Resource resource) {
        Verification verification = type.create(resource, name);
        do {
            verification.setId(EcoreUtil.generateUUID());
        } while (this.haveIDConflict(verification.getId()));
    }

    public IVerification getVerification(String name) {
        return new Q7Verification(this, name);
    }

    private <V> V accessFolderInfo(Openable.ThrowingFunction<Q7FolderInfo, V> infoToValue) throws ModelException, InterruptedException {
        return (V)this.openAndAccessInfo(info -> infoToValue.apply((Q7FolderInfo)info), null);
    }
}

