/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.ext;

import com.google.common.io.Closer;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.rcptt.launching.ext.BundleStart;
import org.eclipse.rcptt.util.StringUtils;
import org.osgi.framework.BundleException;

public class StartLevelSupport {
    public static final String START_LEVEL_ATTR = "Runtime-StartLevel";
    public static final String AUTO_START_ATTR = "Runtime-AutoStart";
    private static final Map<String, BundleStart> predefined = new HashMap<String, BundleStart>();

    static {
        predefined.put("org.eclipse.equinox.weaving.aspectj", BundleStart.fromModelString("1:true"));
        predefined.put("org.aspectj.runtime", BundleStart.fromModelString("1:true"));
        predefined.put("org.eclipse.osgi", BundleStart.fromModelString("-1:true"));
        predefined.put("org.eclipse.equinox.ds", BundleStart.fromModelString("2:true"));
        predefined.put("org.eclipse.equinox.common", BundleStart.fromModelString("2:true"));
        predefined.put("org.eclipse.equinox.simpleconfigurator", BundleStart.fromModelString("1:true"));
        predefined.put("org.eclipse.update.configurator", BundleStart.fromModelString(String.format("%s:%s", "3", "true")));
        predefined.put("org.eclipse.core.runtime", BundleStart.fromModelString("default:true"));
    }

    public static BundleStart getStartInfo(String manifest, BundleStart hint) throws BundleException {
        Map headers;
        String q7sl = null;
        String q7as = null;
        try {
            headers = ManifestElement.parseBundleManifest((InputStream)new ByteArrayInputStream(manifest.getBytes(StandardCharsets.UTF_8)), new HashMap(10));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read memmory array", e);
        }
        if (headers == null) {
            throw new IllegalArgumentException("Could not parse manifest:\n" + manifest);
        }
        q7sl = StringUtils.safeToString(headers.get(START_LEVEL_ATTR));
        q7as = StringUtils.safeToString(headers.get(AUTO_START_ATTR));
        if (q7sl != null || q7as != null) {
            return BundleStart.fromQ7Headers(q7sl, q7as);
        }
        if (!hint.isDefault()) {
            return hint;
        }
        String id = (String)headers.get("Bundle-SymbolicName");
        BundleStart result = predefined.getOrDefault(id, hint);
        return result;
    }

    public static String loadManifest(String path) throws IOException {
        Closer closer;
        block14: {
            String string;
            block15: {
                Throwable throwable = null;
                Object var2_3 = null;
                closer = Closer.create();
                try {
                    InputStream manifestStream = null;
                    File dirOrJar = new File(path);
                    String extension = new Path(path).getFileExtension();
                    if (extension != null && extension.equals("jar") && dirOrJar.isFile()) {
                        ZipFile jarFile = (ZipFile)closer.register((Closeable)new ZipFile(dirOrJar, 1));
                        ZipEntry manifestEntry = jarFile.getEntry("META-INF/MANIFEST.MF");
                        if (manifestEntry != null) {
                            manifestStream = (InputStream)closer.register((Closeable)jarFile.getInputStream(manifestEntry));
                        }
                    } else {
                        File file = new File(dirOrJar, "META-INF/MANIFEST.MF");
                        if (file.exists()) {
                            manifestStream = (InputStream)closer.register((Closeable)new FileInputStream(file));
                        }
                    }
                    if (manifestStream == null) break block14;
                    string = new Scanner(manifestStream).useDelimiter("\\A").next();
                    if (closer == null) break block15;
                }
                catch (Throwable throwable2) {
                    try {
                        if (closer != null) {
                            closer.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                closer.close();
            }
            return string;
        }
        if (closer != null) {
            closer.close();
        }
        return "";
    }
}

