/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.ecl.parser.model;

import org.eclipse.rcptt.core.ecl.model.Declaration;
import org.eclipse.rcptt.core.ecl.model.IDeclContainer;
import org.eclipse.rcptt.core.ecl.model.ProcDecl;
import org.eclipse.rcptt.core.ecl.parser.ast.Arg;
import org.eclipse.rcptt.core.ecl.parser.ast.Command;
import org.eclipse.rcptt.core.ecl.parser.ast.Id;
import org.eclipse.rcptt.core.ecl.parser.ast.LiteralArg;
import org.eclipse.rcptt.core.ecl.parser.ast.Node;
import org.eclipse.rcptt.core.ecl.parser.ast.Reference;
import org.eclipse.rcptt.core.ecl.parser.ast.Script;
import org.eclipse.rcptt.core.ecl.parser.model.NodePath;
import org.eclipse.rcptt.core.ecl.parser.model.PathBuilder;

public class Resolver {
    public static Reference resolve(Script script, int offset, IDeclContainer cont) {
        boolean isArgName;
        NodePath path = PathBuilder.path(script, offset);
        Node lastNode = path.lastNode();
        if (!(lastNode instanceof Id)) {
            return null;
        }
        Id id = (Id)lastNode;
        Node parent = path.fromEnd(1);
        boolean isCommand = parent instanceof Command;
        boolean isArgValue = parent instanceof LiteralArg && ((LiteralArg)parent).value.contains(offset);
        boolean bl = isArgName = parent instanceof Arg && ((Arg)parent).name != null && ((Arg)parent).name.contains(offset);
        if (!(isCommand || isArgValue || isArgName)) {
            return null;
        }
        boolean dollar = id.text.startsWith("$");
        if (isArgValue && !dollar) {
            return null;
        }
        boolean dash = id.text.startsWith("-");
        if (isArgName && !dash) {
            return null;
        }
        Declaration decl = null;
        if (isCommand) {
            decl = dollar ? cont.resolveVar(id.text.substring(1)) : cont.resolveProc(id.text);
        } else if (isArgName) {
            Command command = path.lastOf(Command.class);
            if (command == null) {
                return null;
            }
            ProcDecl proc = cont.resolveProc(command.name.text);
            if (proc == null) {
                return null;
            }
            decl = proc.resolveArg(id.text.substring(1));
        } else if (isArgValue) {
            decl = cont.resolveVar(id.text.substring(1));
        }
        if (decl == null) {
            return null;
        }
        return new Reference(id, decl);
    }
}

