/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.toc;

import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentRange;
import org.eclipse.pde.internal.core.text.IDocumentTextNode;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.eclipse.pde.internal.ua.core.toc.text.Toc;
import org.eclipse.pde.internal.ua.core.toc.text.TocModel;
import org.eclipse.pde.internal.ua.core.toc.text.TocObject;
import org.eclipse.pde.internal.ua.ui.PDEUserAssistanceUIPlugin;
import org.eclipse.pde.internal.ua.ui.PDEUserAssistanceUIPluginImages;
import org.eclipse.pde.internal.ua.ui.editor.toc.TocBlock;
import org.eclipse.pde.internal.ua.ui.editor.toc.TocMessages;
import org.eclipse.pde.internal.ua.ui.editor.toc.TocSourcePage;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDEMasterDetailsBlock;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class TocPage
extends PDEFormPage
implements IModelChangedListener {
    public static final String PAGE_ID = "tocPage";
    private final TocBlock fBlock = new TocBlock(this);

    public TocPage(FormEditor editor) {
        super(editor, PAGE_ID, TocMessages.TocPage_title);
    }

    public PDEMasterDetailsBlock getBlock() {
        return this.fBlock;
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        TocModel model = (TocModel)this.getModel();
        if (model == null || !model.isLoaded()) {
            this.createErrorContent(managedForm);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), "org.eclipse.pde.doc.user.toc_editor");
        super.createFormContent(managedForm);
        form.setImage(PDEUserAssistanceUIPlugin.getDefault().getLabelProvider().get(PDEUserAssistanceUIPluginImages.DESC_TOC_OBJ));
        this.setFormTitle(form, model);
        this.fBlock.createContent(managedForm);
        this.fBlock.getMasterSection().fireSelection();
        model.addModelChangedListener((IModelChangedListener)this);
    }

    private void createErrorContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        form.setMessage(TocMessages.TocPage_errorMessage2, 3);
    }

    private void setFormTitle(ScrolledForm form, TocModel model) {
        String title = PDETextHelper.translateReadText((String)model.getToc().getFieldLabel());
        if (title.length() > 0) {
            form.setText(title);
        } else {
            form.setText(TocMessages.TocPage_title);
        }
    }

    public void dispose() {
        TocModel tocModel = (TocModel)this.getModel();
        if (tocModel != null) {
            tocModel.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 3) {
            String changeProperty;
            Object[] objects = event.getChangedObjects();
            TocObject object = (TocObject)objects[0];
            if (object != null && object.getType() == 0 && (changeProperty = event.getChangedProperty()) != null && changeProperty.equals("label")) {
                this.getManagedForm().getForm().setText(PDETextHelper.translateReadText((String)((String)event.getNewValue())));
            }
        } else if (event.getChangeType() == 99) {
            this.handleModelEventWorldChanged(event);
        }
        this.fBlock.modelChanged(event);
    }

    public ISelection getSelection() {
        return this.fBlock.getSelection();
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        TocObject object;
        Object object2;
        Object[] objects = event.getChangedObjects();
        if (objects[0] != null && (object2 = objects[0]) instanceof TocObject && (object = (TocObject)object2).getType() == 0) {
            String newValue = ((Toc)object).getFieldLabel();
            this.getManagedForm().getForm().setText(PDETextHelper.translateReadText((String)newValue));
        }
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            TocModel model = (TocModel)this.getModel();
            if (model == null || !model.isLoaded()) {
                this.createErrorContent(this.getManagedForm());
            } else {
                this.getManagedForm().getForm().setMessage("", 0);
            }
            IFormPage page = this.getPDEEditor().findPage("toc-context");
            if (page instanceof TocSourcePage && ((TocSourcePage)page).getInputContext().isInSourceMode()) {
                ISourceViewer viewer = ((TocSourcePage)page).getViewer();
                if (viewer == null) {
                    return;
                }
                StyledText text = viewer.getTextWidget();
                if (text == null) {
                    return;
                }
                int offset = text.getCaretOffset();
                if (offset < 0) {
                    return;
                }
                IDocumentRange range = ((TocSourcePage)page).getRangeElement(offset, true);
                if (range instanceof IDocumentAttributeNode) {
                    range = ((IDocumentAttributeNode)range).getEnclosingElement();
                } else if (range instanceof IDocumentTextNode) {
                    range = ((IDocumentTextNode)range).getEnclosingElement();
                }
                if (range instanceof TocObject) {
                    this.fBlock.getMasterSection().setSelection((ISelection)new StructuredSelection((Object)range));
                }
            }
        }
    }

    protected String getHelpResource() {
        return "org.eclipse.pde.doc.user.toc_editor";
    }
}

