/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.persistence.plain;

import com.google.common.io.CharSource;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipInputStream;
import org.eclipse.rcptt.core.persistence.plain.IPlainConstants;
import org.eclipse.rcptt.core.persistence.plain.PlainFormatException;
import org.eclipse.rcptt.core.persistence.plain.SeparatorReader;
import org.eclipse.rcptt.util.FileUtil;

public class PlainReader
implements IPlainConstants,
Closeable {
    private BufferedReader reader;
    private final InputStream in;
    public Reader currentSegment;
    private static final List<String> VALID_HEADERS = Arrays.asList("--- RCPTT testcase ---", "--- RCPTT project settings ---", "--- RCPTT verification ---", "--- Q7 testcase ---", "--- Q7 project settings ---", "--- Q7 verification ---");

    public PlainReader(InputStream stream) throws IOException {
        this.in = stream;
        this.reader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(stream), "utf-8"));
    }

    public Map<String, String> readHeader() throws IOException {
        String header = this.reader.readLine();
        if (header == null) {
            return null;
        }
        header = header.trim();
        while (header.startsWith("#")) {
            header = this.reader.readLine();
            if (header == null) {
                return null;
            }
            header = header.trim();
        }
        boolean headerOK = false;
        for (String validHeader : VALID_HEADERS) {
            if (!validHeader.equalsIgnoreCase(header)) continue;
            headerOK = true;
            break;
        }
        if (!headerOK) {
            return null;
        }
        Map<String, String> map = this.readAttributes();
        return map;
    }

    private Map<String, String> readAttributes() throws IOException {
        String line;
        HashMap<String, String> map = new HashMap<String, String>();
        while ((line = this.reader.readLine()) != null && line.trim().length() != 0) {
            int pos = line.indexOf(": ");
            if (pos != -1) {
                String key = line.substring(0, pos);
                String value = FileUtil.unescape((String)line.substring(pos + 2));
                if (map.containsKey(key)) {
                    throw new PlainFormatException("Wrong RCPTT plain format, duplicate attribute entry.");
                }
                map.put(key, value);
                continue;
            }
            if (line.trim().endsWith(":")) continue;
            throw new PlainFormatException("Wrong RCPTT plain format");
        }
        return map;
    }

    /*
     * Unable to fully structure code
     */
    public Entry readEntry() throws IOException {
        if (this.currentSegment != null) {
            this.currentSegment.skip(0x7FFFFFFFFFFFFFFFL);
            this.currentSegment.close();
            this.currentSegment = null;
        }
        if ((entryHeader = this.reader.readLine()) != null) ** GOTO lbl9
        return null;
lbl-1000:
        // 1 sources

        {
            entryHeader = this.reader.readLine();
lbl9:
            // 2 sources

            ** while (entryHeader != null && entryHeader.trim().length() == 0)
        }
lbl10:
        // 1 sources

        if (entryHeader == null) {
            return null;
        }
        if (entryHeader.startsWith("------=_")) {
            attributes = this.readAttributes();
            name = attributes.get("Entry-Name");
            separatorReader = new SeparatorReader(this.reader, new SeparatorReader.Separator.Any(new SeparatorReader.Separator[]{new SeparatorReader.Separator.Exact(entryHeader + "--\n"), new SeparatorReader.Separator.Exact(entryHeader + "--\r\n")}));
            this.currentSegment = separatorReader;
            charSource = new CharSource(){

                public Reader openStream() throws IOException {
                    return new FilterReader(separatorReader){

                        @Override
                        public void close() throws IOException {
                        }
                    };
                }
            };
            return new Entry(name, attributes, charSource);
        }
        throw new PlainFormatException("Wrong RCPTT plain format. Invalid entry header: " + entryHeader);
    }

    @Override
    public void close() {
        FileUtil.safeClose((Closeable)this.reader);
        FileUtil.safeClose((Closeable)this.in);
    }

    public static class Entry {
        public final String name;
        private final CharSource segment;
        public final Map<String, String> attributes;

        public Entry(String name, Map<String, String> attributes, CharSource segment) {
            this.name = Objects.requireNonNull(name);
            this.attributes = Objects.requireNonNull(attributes);
            this.segment = Objects.requireNonNull(segment);
        }

        public InputStream getContent() throws IOException {
            String contentType = this.attributes.get("Content-Type");
            if (contentType != null && contentType.contains("text")) {
                String suffix;
                String content = this.segment.read();
                if ((content = content.replaceAll("\r\n", "\n")).endsWith(suffix = "\n")) {
                    content = content.substring(0, content.length() - suffix.length());
                }
                return new ByteArrayInputStream(content.getBytes(ENCODING_OBJECT));
            }
            if (contentType != null && contentType.contains("binary")) {
                InputStream segmentBytes = this.segment.asByteSource(ENCODING_OBJECT).openStream();
                InputStream decoded = Base64.getMimeDecoder().wrap(segmentBytes);
                ZipInputStream zin = new ZipInputStream(decoded);
                zin.getNextEntry();
                return zin;
            }
            throw new PlainFormatException("Entry " + this.name + " has unknown content type");
        }

        public String toString() {
            return this.name;
        }
    }
}

