/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.comparator.java;

import org.eclipse.equinox.p2.internal.repository.comparator.java.ClassFileStruct;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ClassFormatException;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ConstantPool;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ConstantPoolEntry;

public class ClassFileAttribute
extends ClassFileStruct {
    public static final ClassFileAttribute[] NO_ATTRIBUTES = new ClassFileAttribute[0];
    private final long attributeLength;
    private final int attributeNameIndex;
    private final char[] attributeName;

    public ClassFileAttribute(byte[] classFileBytes, ConstantPool constantPool, int offset) throws ClassFormatException {
        this.attributeNameIndex = this.u2At(classFileBytes, 0, offset);
        this.attributeLength = this.u4At(classFileBytes, 2, offset);
        ConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(this.attributeNameIndex);
        if (constantPoolEntry.getKind() != 1) {
            throw new ClassFormatException(3);
        }
        this.attributeName = constantPoolEntry.getUtf8Value();
    }

    public int getAttributeNameIndex() {
        return this.attributeNameIndex;
    }

    public char[] getAttributeName() {
        return this.attributeName;
    }

    public long getAttributeLength() {
        return this.attributeLength;
    }
}

