/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.dialogs;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public abstract class LinkMessageDialogWithToggle
extends MessageDialogWithToggle {
    protected static final String TOGGLE_MESSAGE = "Never show this dialog again";
    private static final Pattern LINK_PATTERN = Pattern.compile("<a>(.*)</a>");
    private final String linkMessage;
    private final String link;
    private final IEclipsePreferences prefs;

    public LinkMessageDialogWithToggle(Shell parentShell, String dialogTitle, Image image, String linkMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String toggleMessage, boolean toggleState, String prefKey, IEclipsePreferences prefs) {
        super(parentShell, dialogTitle, image, null, dialogImageType, dialogButtonLabels, defaultIndex, toggleMessage, toggleState);
        Matcher matcher = LINK_PATTERN.matcher(linkMessage);
        this.linkMessage = linkMessage;
        String link = null;
        while (matcher.find()) {
            if (link != null) {
                throw new IllegalArgumentException("More than one link found");
            }
            link = matcher.group(1);
        }
        this.link = link != null ? (link.contains("@") ? "mailto:" + link : link) : null;
        this.setPrefKey(prefKey);
        this.prefs = prefs;
        this.setShellStyle(this.getShellStyle() | 0x10000000);
    }

    protected Control createMessageArea(Composite composite) {
        super.createMessageArea(composite);
        Link link = new Link(composite, 0);
        link.setText(this.linkMessage);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)link);
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Program.launch((String)LinkMessageDialogWithToggle.this.link);
            }
        });
        return composite;
    }

    public int open() {
        String show = this.prefs.get(this.getPrefKey(), "prompt");
        if (!"never".equals(show)) {
            int result = super.open();
            if (this.getToggleState()) {
                this.prefs.put(this.getPrefKey(), "never");
            }
            return result;
        }
        return 0;
    }
}

