/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors;

import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.controls.SuggestionItem;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PropertyCellEditor
extends TextCellEditor {
    private Text text;
    private Shell shell;
    private org.eclipse.swt.widgets.List list;
    private Shell description;
    private Browser browser;
    private Button button;
    private List<SuggestionItem> suggestions;
    private String descriptionData;
    private boolean filterEnabled;
    private boolean valueIsSelectedFromList = false;
    private int listMaxHeight;
    private int descWidth;
    private int descHeight;
    private static final int LIST_MAX_HEIGHT = 200;
    private static final int DESC_WIDTH = 350;
    private static final int DESC_HEIGHT = 220;
    private static String styles = null;

    public PropertyCellEditor(Composite parent, List<SuggestionItem> suggestions) {
        super(parent);
        this.suggestions = suggestions;
        this.filterEnabled = false;
        this.text = (Text)super.getControl();
        this.createPopup(this.text);
        this.createButton();
        this.addListeners();
    }

    public void completeEdit() {
    }

    private void createPopup(Text textField) {
        this.text = textField;
        int popupStyle = 16396;
        int listStyle = 516;
        this.shell = new Shell(this.text.getShell(), popupStyle);
        this.list = new org.eclipse.swt.widgets.List((Composite)this.shell, listStyle);
        this.description = new Shell(this.text.getShell(), popupStyle);
        this.description.setLayout((Layout)new FormLayout());
        this.description.setForeground(this.text.getDisplay().getSystemColor(28));
        this.description.setBackground(this.text.getDisplay().getSystemColor(29));
        this.browser = new Browser((Composite)this.description, 0);
        this.browser.setJavascriptEnabled(false);
        this.browser.setForeground(this.text.getDisplay().getSystemColor(28));
        this.browser.setBackground(this.text.getDisplay().getSystemColor(29));
        this.browser.setMenu(new Menu((Decorations)this.description, 0));
        this.browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                event.required = true;
            }
        });
        this.listMaxHeight = 200;
        this.descWidth = 350;
        this.descHeight = 220;
    }

    private void createButton() {
        Composite composite = new Composite((Composite)this.description, 0);
        FormData data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        composite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 3;
        layout.marginHeight = 3;
        layout.verticalSpacing = 3;
        layout.horizontalSpacing = 3;
        composite.setLayout((Layout)layout);
        this.button = new Button(composite, 0x800008);
        this.button.setText("Copy to the clipboard");
        this.button.setImage(Images.getImageDescriptor("IMG_TOOL_COPY").createImage());
        Font font = this.button.getFont();
        FontData fontdata = font.getFontData()[0];
        fontdata.setHeight(fontdata.getHeight() - 2);
        this.button.setFont(new Font(font.getDevice(), fontdata));
    }

    public void activate() {
        super.activate();
    }

    public void deactivate() {
        if (this.shell == null) {
            return;
        }
        if (!this.isActive()) {
            super.deactivate();
            return;
        }
        this.addJob();
    }

    protected void focusLost() {
    }

    protected boolean dependsOnExternalFocusListener() {
        return false;
    }

    private void open() {
        if (!this.isActive()) {
            return;
        }
        this.setItems(this.suggestions);
        this.setShellBounds();
        this.setChildElementsBounds();
        this.filterValues(this.text.getText());
        this.shell.setVisible(true);
        this.text.setFocus();
    }

    private void close() {
        if (!this.shell.isDisposed()) {
            this.shell.setVisible(false);
        }
        if (!this.description.isDisposed()) {
            this.description.setVisible(false);
        }
    }

    private void addListeners() {
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PropertyCellEditor.this.valueIsSelectedFromList) {
                    PropertyCellEditor.this.valueIsSelectedFromList = false;
                    return;
                }
                PropertyCellEditor.this.filterValues(PropertyCellEditor.this.text.getText());
            }
        });
        this.text.getShell().addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                PropertyCellEditor.this.close();
            }

            public void controlResized(ControlEvent e) {
                PropertyCellEditor.this.close();
            }
        });
        this.shell.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                PropertyCellEditor.this.setChildElementsBounds();
            }
        });
        this.list.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PropertyCellEditor.this.selectValueFromList(PropertyCellEditor.this.list.getSelectionIndex());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.list.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                PropertyCellEditor.this.selectValueFromList(PropertyCellEditor.this.list.getSelectionIndex());
                PropertyCellEditor.this.completeEdit();
            }
        });
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                switch (e.detail) {
                    case 64: {
                        if (e.keyCode != 0x1000002) break;
                        int oldIndex = PropertyCellEditor.this.list.getSelectionIndex();
                        PropertyCellEditor.this.selectValueFromList(Math.min(oldIndex + 1, PropertyCellEditor.this.list.getItemCount() - 1));
                        e.detail = 0;
                        e.doit = false;
                        break;
                    }
                    case 32: {
                        if (e.keyCode != 0x1000001) break;
                        int oldIndex = PropertyCellEditor.this.list.getSelectionIndex();
                        PropertyCellEditor.this.selectValueFromList(Math.max(oldIndex - 1, 0));
                        e.detail = 0;
                        e.doit = false;
                    }
                }
            }
        });
        this.button.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (PropertyCellEditor.this.descriptionData != null && !PropertyCellEditor.this.descriptionData.equals("")) {
                    Clipboard clipboard = new Clipboard(Display.getCurrent());
                    TextTransfer transfer = TextTransfer.getInstance();
                    clipboard.setContents(new Object[]{PropertyCellEditor.this.descriptionData}, new Transfer[]{transfer});
                }
            }
        });
        FocusListener focusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (e.widget == PropertyCellEditor.this.text && !PropertyCellEditor.this.isVisible()) {
                    PropertyCellEditor.this.open();
                    return;
                }
                if (PropertyCellEditor.this.text != null) {
                    PropertyCellEditor.this.cancelJobs();
                }
            }

            public void focusLost(FocusEvent e) {
                PropertyCellEditor.this.addJob();
            }
        };
        this.text.addFocusListener(focusListener);
        this.browser.addFocusListener(focusListener);
        this.list.addFocusListener(focusListener);
        this.button.addFocusListener(focusListener);
        this.shell.addFocusListener(focusListener);
        this.description.addFocusListener(focusListener);
        Listener keyDown = new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\r') {
                    PropertyCellEditor.this.completeEdit();
                } else {
                    PropertyCellEditor.this.text.notifyListeners(1, e);
                }
            }
        };
        this.list.addListener(1, keyDown);
        this.browser.addListener(1, keyDown);
        this.button.addListener(1, keyDown);
        Listener traverse = new Listener(){

            public void handleEvent(Event e) {
                PropertyCellEditor.this.text.notifyListeners(31, e);
            }
        };
        this.list.addListener(31, traverse);
        this.browser.addListener(31, traverse);
        this.button.addListener(31, traverse);
        this.text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PropertyCellEditor.this.handleDefaultSelection(e);
            }
        });
    }

    private void addJob() {
        this.cancelJobs();
        Job job = new Job("Deactivate"){

            public boolean belongsTo(Object family) {
                return family == PropertyCellEditor.this;
            }

            protected IStatus run(IProgressMonitor monitor) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Control control = Display.getDefault().getFocusControl();
                        if (control == (this).PropertyCellEditor.this.browser || control != null && control.getParent() != null && control.getParent().getParent() != null && control.getParent().getParent() == (this).PropertyCellEditor.this.browser) {
                            (this).PropertyCellEditor.this.list.setFocus();
                            return;
                        }
                        PropertyCellEditor.this.deactivateAll();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule(100L);
    }

    private void cancelJobs() {
        Job.getJobManager().cancel((Object)this);
    }

    private void deactivateAll() {
        if (this.shell != null) {
            this.close();
        }
        super.fireApplyEditorValue();
        super.deactivate();
    }

    public boolean isVisible() {
        return this.shell.getVisible();
    }

    public boolean isActive() {
        return this.suggestions != null && !this.suggestions.isEmpty();
    }

    private void selectValueFromList(int index) {
        this.valueIsSelectedFromList = true;
        if (index >= 0 && index < this.list.getItemCount()) {
            String value = this.list.getItem(index);
            this.text.setText(value);
            this.text.selectAll();
            this.list.select(index);
            this.list.showSelection();
            SuggestionItem.SuggestionDescription desc = this.getDescription(value);
            if (desc != null && desc.getText() != null && !desc.getText().equals("") && desc.getHTML() != null && !desc.getHTML().equals("")) {
                this.descriptionData = desc.getText();
                this.browser.setText(PropertyCellEditor.applyStyling(desc.getHTML()));
                this.description.setVisible(true);
            } else {
                this.description.setVisible(false);
                this.descriptionData = "";
                this.browser.setText("");
            }
        }
    }

    private void filterValues(String value) {
        if (!this.filterEnabled) {
            return;
        }
        if (value == null || value.trim().length() == 0) {
            value = "";
        }
        ArrayList<String> items = new ArrayList<String>();
        for (SuggestionItem suggestion : this.suggestions) {
            String name = suggestion.getName();
            if (!name.toLowerCase().startsWith(value.toLowerCase()) && !value.isEmpty()) continue;
            items.add(name);
        }
        this.list.setItems(items.toArray(new String[0]));
        this.list.deselectAll();
    }

    private void setItems(List<SuggestionItem> suggestions) {
        TreeSet<String> set = new TreeSet<String>();
        for (SuggestionItem suggestion : suggestions) {
            set.add(suggestion.getName());
        }
        String[] items = set.toArray(new String[0]);
        this.list.setItems(items);
        this.suggestions = suggestions;
    }

    private SuggestionItem.SuggestionDescription getDescription(String name) {
        for (SuggestionItem suggestion : this.suggestions) {
            if (!name.equals(suggestion.getName())) continue;
            return suggestion.getDescription();
        }
        return null;
    }

    private static String applyStyling(String html) {
        String styles = PropertyCellEditor.loadStyles();
        FontData fontData = JFaceResources.getDialogFont().getFontData()[0];
        styles = HTMLPrinter.convertTopLevelFont((String)styles, (FontData)fontData);
        StringBuffer b = new StringBuffer(html);
        b.insert(0, "</style></head><body>");
        b.insert(0, styles);
        b.insert(0, "<html><head><style type=\"text/css\">");
        b.append("</body></html>");
        return b.toString();
    }

    private static String loadStyles() {
        if (styles != null) {
            return styles;
        }
        try {
            URL url = Q7UIPlugin.getDefault().getBundle().getResource("/docs.css");
            if (url == null) {
                styles = "";
                return "";
            }
            styles = Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
            return styles;
        }
        catch (IOException e) {
            Q7UIPlugin.log(e);
            styles = "";
            return "";
        }
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    public void setFilterEnabled(boolean filterEnabled) {
        this.filterEnabled = filterEnabled;
    }

    public int getListMaximumHeight() {
        return this.listMaxHeight;
    }

    public void setListMaximumHeight(int height) {
        this.listMaxHeight = height;
    }

    public int getDescriptionWidth() {
        return this.descWidth;
    }

    public void setDescriptionWidth(int width) {
        this.descWidth = width;
    }

    public int getDescriptionHeight() {
        return this.descHeight;
    }

    public void setDescriptionHeight(int height) {
        this.descHeight = height;
    }

    private void setShellBounds() {
        int spaceBelow;
        int spaceAbove;
        Rectangle textBounds = this.text.getBounds();
        Rectangle screenBounds = this.shell.getDisplay().getBounds();
        Point textLocation = this.text.getParent().toDisplay(textBounds.x, textBounds.y);
        Point popupSize = this.list.computeSize(textBounds.width, -1, false);
        int shellX = textLocation.x;
        int shellY = textLocation.y;
        popupSize.x = textBounds.width;
        if (popupSize.y > this.listMaxHeight) {
            popupSize.y = this.listMaxHeight;
        }
        if ((spaceAbove = textLocation.y - 30) > (spaceBelow = screenBounds.height - (textLocation.y + textBounds.height) - 30) && popupSize.y > spaceBelow) {
            if (popupSize.y > spaceAbove) {
                popupSize.y = spaceAbove;
            }
            shellY -= popupSize.y;
        } else {
            if (popupSize.y > spaceBelow) {
                popupSize.y = spaceBelow;
            }
            shellY += textBounds.height;
        }
        this.shell.setBounds(shellX, shellY, popupSize.x, popupSize.y);
    }

    private void setChildElementsBounds() {
        Rectangle shellBounds = this.shell.getBounds();
        Rectangle screenBounds = this.shell.getDisplay().getBounds();
        Point buttonSize = this.button.getParent().getSize();
        int descX = shellBounds.x;
        int descY = shellBounds.y;
        int spaceBefore = shellBounds.x - 30;
        int spaceAfter = screenBounds.width - (shellBounds.x + shellBounds.width) - 30;
        if (spaceBefore > spaceAfter && this.descWidth > spaceAfter) {
            if (this.descWidth > spaceBefore) {
                this.descWidth = spaceBefore;
            }
            descX -= this.descWidth;
        } else {
            if (this.descWidth > spaceAfter) {
                this.descWidth = spaceAfter;
            }
            descX += shellBounds.width;
        }
        this.list.setSize(shellBounds.width, shellBounds.height);
        this.description.setBounds(descX, descY, this.descWidth, this.descHeight);
        this.browser.setSize(this.descWidth, this.descHeight - buttonSize.y);
    }
}

