/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.panels.assertion;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.tesla.core.protocol.Assert;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolFactory;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.ui.PropertyNode;
import org.eclipse.rcptt.tesla.core.ui.PropertyNodeType;
import org.eclipse.rcptt.ui.panels.assertion.AssertGroup;

public class AssertionUtils {
    public static Assert createAssert(String name, Object value, EClassifier valueType, Element element, String category) {
        Assert a = ProtocolFactory.eINSTANCE.createAssert();
        a.setAttribute(name);
        a.setValue(value.toString());
        a.setValueType(valueType);
        a.setCategory(category);
        a.setElement((Element)EcoreUtil.copy((EObject)element));
        return a;
    }

    public static void fillAdvancedPropertiesGroup(List<Object> group, EList<PropertyNode> propertyNodes, Element element, String prefixPath) {
        group.clear();
        if (prefixPath == null) {
            prefixPath = "";
        }
        if (((String)prefixPath).length() > 0) {
            prefixPath = (String)prefixPath + ".";
        }
        for (PropertyNode node : propertyNodes) {
            if (node.getType().equals((Object)PropertyNodeType.PROPERTY)) {
                group.add(AssertionUtils.createAssert((String)prefixPath + node.getName(), node.getValue(), null, element, "advanced"));
                continue;
            }
            ArrayList<Object> reference = new ArrayList<Object>();
            reference.add(new ReferencePlaceholder(element));
            group.add(new AssertGroup(node.getName(), reference));
        }
    }

    public static class ReferencePlaceholder {
        private final Element element;

        ReferencePlaceholder(Element element) {
            this.element = (Element)EcoreUtil.copy((EObject)element);
        }

        public Element getElement() {
            return this.element;
        }
    }
}

