/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.verification;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.rcptt.core.VerificationType;
import org.eclipse.rcptt.core.VerificationTypeManager;
import org.eclipse.rcptt.core.ecl.core.model.CreateWidgetVerificationParam;
import org.eclipse.rcptt.core.ecl.core.model.Q7CoreFactory;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.ScenarioPackage;
import org.eclipse.rcptt.core.scenario.Verification;
import org.eclipse.rcptt.core.scenario.WidgetVerification;
import org.eclipse.rcptt.internal.launching.aut.BaseAutLaunch;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.ui.editors.EditorHeader;
import org.eclipse.rcptt.ui.editors.IQ7Editor;
import org.eclipse.rcptt.ui.editors.IQ7EditorActionsProvider;
import org.eclipse.rcptt.ui.editors.NamedElementEditorActions;
import org.eclipse.rcptt.ui.editors.StyledTextNamedElementActions;
import org.eclipse.rcptt.ui.editors.ecl.EclStyledTextHighlighter;
import org.eclipse.rcptt.ui.launching.LaunchUtils;
import org.eclipse.rcptt.ui.recording.WidgetPicker;
import org.eclipse.rcptt.util.StringUtils;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class WidgetVerificationEditor
implements IQ7Editor<WidgetVerification>,
IQ7EditorActionsProvider {
    protected final DataBindingContext dbc = new DataBindingContext();
    private IVerification verification;
    private IManagedForm form;
    private EditorHeader header;
    private final UpdateValueStrategy<String, String> selectorStrategy = new EMFUpdateValueStrategy(){
        {
            1 typed = this;
            typed.setBeforeSetValidator((IValidator)new IValidator<String>(){

                public IStatus validate(String value) {
                    String selector = value;
                    if (StringUtils.isBlank((String)selector)) {
                        (this).WidgetVerificationEditor.this.header.getReplayButton().setEnabled(false);
                        return ValidationStatus.warning((String)"Empty widget selector.");
                    }
                    (this).WidgetVerificationEditor.this.header.getReplayButton().setEnabled(true);
                    return ValidationStatus.ok();
                }
            });
        }
    };
    StyledText selectorText;

    public IVerification getElement() {
        return this.verification;
    }

    public WidgetVerification getWidgetVerification() {
        try {
            return (WidgetVerification)this.getElement().getNamedElement();
        }
        catch (ModelException e) {
            Q7UIPlugin.log(e);
            return null;
        }
    }

    protected Control createWidgetControls(Composite parent, FormToolkit toolkit, IWorkbenchSite site, final EditorHeader header) {
        this.header = header;
        Composite box = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)box);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(box);
        Label label = toolkit.createLabel(box, "Widget:");
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        label.setBackground(null);
        this.selectorText = new StyledText(box, 2052);
        GridDataFactory.fillDefaults().grab(true, false).hint(1, -1).applyTo((Control)this.selectorText);
        this.selectorText.setFont(JFaceResources.getTextFont());
        new EclStyledTextHighlighter().install(this.selectorText);
        IObservableValue selector = EMFObservables.observeValue((EObject)this.getWidgetVerification(), (EStructuralFeature)ScenarioPackage.Literals.WIDGET_VERIFICATION__SELECTOR);
        Binding selectorBinding = this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.selectorText), selector, this.selectorStrategy, this.selectorStrategy);
        ControlDecorationSupport.create((ValidationStatusProvider)selectorBinding, (int)16512, (Composite)box, (ControlDecorationUpdater)new ControlDecorationUpdater(){

            protected void update(ControlDecoration decoration, IStatus status) {
                decoration.setMarginWidth(2);
                super.update(decoration, status);
            }
        });
        Button button = toolkit.createButton(box, "Pick...", 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutLaunch launch = LaunchUtils.selectAutLaunch();
                if (launch == null) {
                    return;
                }
                VerificationType type = VerificationTypeManager.getInstance().getTypeByVerification((Verification)WidgetVerificationEditor.this.getWidgetVerification());
                String selector = WidgetPicker.activate(null, (BaseAutLaunch)launch, type);
                if (selector != null) {
                    WidgetVerificationEditor.this.selectorText.setText(selector);
                    header.getRecordButton().notifyListeners(13, new Event());
                }
            }
        });
        return box;
    }

    @Override
    public void setElement(IQ7NamedElement verification) {
        this.verification = (IVerification)verification;
    }

    @Override
    public void copyContentFrom(WidgetVerification verification, IProgressMonitor monitor) throws CoreException {
        this.getElement().getType().getMaker().captureContents(this.getElement(), (Verification)verification, monitor);
    }

    @Override
    public void save() throws CoreException {
    }

    @Override
    public void dispose() {
        this.dbc.dispose();
    }

    @Override
    public void select(Object data) {
    }

    @Override
    public EObject getCreateParam(AutLaunch launch) {
        CreateWidgetVerificationParam p = Q7CoreFactory.eINSTANCE.createCreateWidgetVerificationParam();
        p.setSelector(this.getWidgetVerification().getSelector());
        return p;
    }

    @Override
    public void setForm(IManagedForm form) {
        this.form = form;
    }

    public IManagedForm getForm() {
        return this.form;
    }

    @Override
    public NamedElementEditorActions.INamedElementActions createActions() {
        return new StyledTextNamedElementActions(this.selectorText);
    }
}

