/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.resources.impl;

import java.net.URI;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.resources.impl.FileBuffersUtils;
import org.eclipse.rcptt.tesla.ecl.impl.UIRunnable;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class WSRunnables {
    public static IWorkspaceRunnable refreshWorkspace = new IWorkspaceRunnable(){

        public void run(IProgressMonitor monitor) throws CoreException {
            Job[] autobuildJobs;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            WSRunnables.autoDeleteUnexistingProjects(root);
            try {
                root.refreshLocal(2, null);
            }
            catch (CoreException e) {
                RcpttPlugin.log((String)("Failed to refresh workspace on first time cause: + " + e.getMessage()), (Throwable)e);
                root.refreshLocal(2, null);
            }
            Job[] jobArray = autobuildJobs = Job.getJobManager().find(ResourcesPlugin.FAMILY_AUTO_BUILD);
            int n = autobuildJobs.length;
            int n2 = 0;
            while (n2 < n) {
                Job job = jobArray[n2];
                job.schedule();
                ++n2;
            }
        }
    };
    public static UIRunnable<Object> clearHistory = new UIRunnable<Object>(){

        public Object run() throws CoreException {
            ResourcesPlugin.getWorkspace().getRoot().clearHistory((IProgressMonitor)new NullProgressMonitor());
            return null;
        }
    };
    public static UIRunnable<Object> clearAllFileBuffers = new UIRunnable<Object>(){

        public Object run() throws CoreException {
            FileBuffersUtils.getFileBuffers().clearAll();
            return null;
        }
    };
    public static UIRunnable<Object> closeEditorsWithResources = new UIRunnable<Object>(){

        public Object run() throws CoreException {
            IWorkbenchWindow[] workbenchWindows;
            IWorkbenchWindow[] iWorkbenchWindowArray = workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n = workbenchWindows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchPage[] pages;
                IWorkbenchWindow win = iWorkbenchWindowArray[n2];
                IWorkbenchPage[] iWorkbenchPageArray = pages = win.getPages();
                int n3 = pages.length;
                int n4 = 0;
                while (n4 < n3) {
                    IEditorReference[] refs;
                    IWorkbenchPage page = iWorkbenchPageArray[n4];
                    IEditorReference[] iEditorReferenceArray = refs = page.getEditorReferences();
                    int n5 = refs.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IEditorReference ref = iEditorReferenceArray[n6];
                        this.closeEditor(page, ref);
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
            return null;
        }

        private void closeEditor(IWorkbenchPage page, IEditorReference ref) throws PartInitException {
            IEditorInput editorInput = ref.getEditorInput();
            if (!editorInput.exists()) {
                return;
            }
            int attemptCount = 10;
            while (attemptCount-- > 0) {
                IWorkbenchPart part = ref.getPart(false);
                if (part == null) {
                    return;
                }
                try {
                    page.closeEditor((IEditorPart)part, false);
                }
                catch (Throwable e) {
                    RcpttPlugin.log((String)"Failed to close editor", (Throwable)e);
                }
            }
        }
    };
    public static UIRunnable<Boolean> clearOperationHistoryEntry = new UIRunnable<Boolean>(){
        private IUndoContext anyContext = new IUndoContext(){

            public boolean matches(IUndoContext context) {
                return true;
            }

            public String getLabel() {
                return "any";
            }
        };

        public Boolean run() throws CoreException {
            try {
                IOperationHistory history = OperationHistoryFactory.getOperationHistory();
                IUndoableOperation[] iUndoableOperationArray = history.getUndoHistory(this.anyContext);
                if (iUndoableOperationArray.length != 0) {
                    IUndoableOperation op = iUndoableOperationArray[0];
                    history.replaceOperation(op, new IUndoableOperation[0]);
                    return true;
                }
                iUndoableOperationArray = history.getRedoHistory(this.anyContext);
                if (iUndoableOperationArray.length != 0) {
                    IUndoableOperation op = iUndoableOperationArray[0];
                    history.replaceOperation(op, new IUndoableOperation[0]);
                    return true;
                }
            }
            catch (Throwable e) {
                RcpttPlugin.log((Throwable)e);
            }
            return false;
        }
    };

    private static void autoDeleteUnexistingProjects(IWorkspaceRoot root) throws CoreException {
        IProject[] projects;
        IProject[] iProjectArray = projects = root.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IFileInfo fileInfo;
            IFileStore store;
            IProject prj = iProjectArray[n2];
            URI uri = prj.getLocationURI();
            if (uri != null && uri.getScheme() != null && (store = EFS.getStore((URI)uri)) != null && (fileInfo = store.fetchInfo()) != null && !fileInfo.exists()) {
                prj.delete(true, true, null);
                RcpttPlugin.infoLog((String)("Q7 workspace context, automatic delete of unexisting project: " + prj.getName()));
            }
            ++n2;
        }
    }
}

