/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui;

import java.net.URL;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Resources
implements BundleActivator {
    private static ImageRegistry imageRegistry;
    private static ScheduledExecutorService scheduler;

    public void start(BundleContext context) throws Exception {
    }

    public void stop(BundleContext context) throws Exception {
        Resources.disposeResources();
    }

    public static synchronized ImageDescriptor getImageDescriptor(String key) {
        ImageRegistry registry = Resources.getImageRegistry();
        ImageDescriptor descriptor = registry.getDescriptor(key);
        if (descriptor == null) {
            ImageDescriptor fromURL = ImageDescriptor.createFromURL((URL)Resources.getImageUrl(key));
            registry.put(key, fromURL);
            return fromURL;
        }
        return descriptor;
    }

    private static URL getImageUrl(String key) {
        URL resource = Resources.class.getResource(key);
        if (resource != null) {
            return resource;
        }
        resource = Resources.class.getResource("/icons/" + key);
        if (resource != null) {
            return resource;
        }
        resource = Resources.class.getResource("/icons/" + key + ".svg");
        if (resource != null) {
            return resource;
        }
        resource = Resources.class.getResource("/icons/" + key + ".gif");
        if (resource != null) {
            return resource;
        }
        resource = Resources.class.getResource("/icons/" + key + ".png");
        if (resource != null) {
            return resource;
        }
        return null;
    }

    public static synchronized Image getImage(String key) {
        if (key.startsWith("$")) {
            try {
                return PlatformUI.getWorkbench().getSharedImages().getImage(key);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        ImageRegistry registry = Resources.getImageRegistry();
        Resources.getImageDescriptor(key);
        return registry.get(key);
    }

    public static synchronized ScheduledExecutorService getScheduler() {
        if (scheduler == null) {
            scheduler = Executors.newScheduledThreadPool(4);
        }
        return scheduler;
    }

    private static synchronized ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry(Display.getCurrent());
        }
        return imageRegistry;
    }

    private static synchronized void disposeResources() {
        if (imageRegistry != null) {
            imageRegistry.dispose();
            imageRegistry = null;
        }
        if (scheduler != null) {
            scheduler.shutdownNow();
            scheduler = null;
        }
    }
}

