/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.views.resolution;

import aQute.bnd.build.model.EE;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.RequirementImpl;
import aQute.bnd.osgi.resource.ResourceUtils;
import aQute.bnd.unmodifiable.Sets;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import java.io.Closeable;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.bnd.ui.FilterPanelPart;
import org.eclipse.pde.bnd.ui.HelpButtons;
import org.eclipse.pde.bnd.ui.Resources;
import org.eclipse.pde.bnd.ui.internal.PartAdapter;
import org.eclipse.pde.bnd.ui.model.repo.ResourceProvider;
import org.eclipse.pde.bnd.ui.model.resolution.CapReqMapContentProvider;
import org.eclipse.pde.bnd.ui.model.resolution.CapabilityLabelProvider;
import org.eclipse.pde.bnd.ui.model.resolution.RequirementWrapper;
import org.eclipse.pde.bnd.ui.model.resolution.RequirementWrapperLabelProvider;
import org.eclipse.pde.bnd.ui.tasks.AnalyseBundleResolutionJob;
import org.eclipse.pde.bnd.ui.tasks.BndBuilderCapReqLoader;
import org.eclipse.pde.bnd.ui.tasks.BndFileCapReqLoader;
import org.eclipse.pde.bnd.ui.tasks.CapReqLoader;
import org.eclipse.pde.bnd.ui.tasks.JarFileCapReqLoader;
import org.eclipse.pde.bnd.ui.tasks.ManifestCapReqLoader;
import org.eclipse.pde.bnd.ui.tasks.ResourceCapReqLoader;
import org.eclipse.pde.bnd.ui.views.ViewEventTopics;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.ViewPart;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.repository.Repository;

public class ResolutionView
extends ViewPart
implements ISelectionListener,
IResourceChangeListener {
    public static final String PLUGIN_ID = "bndtools.core";
    private final List<EE> ees = Arrays.asList(EE.values());
    private Display display = null;
    private Tree reqsTree = null;
    private Table capsTable = null;
    private TreeViewer reqsViewer;
    private TableViewer capsViewer;
    private Label reqsLabel;
    private Label capsLabel;
    private ViewerFilter hideSelfImportsFilter;
    private ViewerFilter hideOptionalRequirements;
    private ViewerFilter filterShowCapsProblems;
    private boolean inputLocked = false;
    private boolean outOfDate = false;
    Set<CapReqLoader> loaders;
    private Job analysisJob;
    private int currentEE = 4;
    private final Set<String> filteredCapabilityNamespaces;
    private Set<Capability> duplicateCapabilitiesWithDifferentHashes = new HashSet<Capability>();
    private final FilterPanelPart reqsFilterPart = new FilterPanelPart(Resources.getScheduler());
    private final FilterPanelPart capsFilterPart = new FilterPanelPart(Resources.getScheduler());
    private static final String SEARCHSTRING_HINT = "Enter search string (Space to separate terms; '*' for partial matches)";
    private CapReqMapContentProvider reqsContentProvider;
    private CapReqMapContentProvider capsContentProvider;
    private final IEventBroker eventBroker = (IEventBroker)PlatformUI.getWorkbench().getService(IEventBroker.class);
    private final IPartListener partAdapter = new PartAdapter(){

        @Override
        public void partActivated(IWorkbenchPart part) {
            CapReqLoader loader;
            IPath location;
            IEditorInput editorInput;
            IFile file;
            if (part == ResolutionView.this) {
                if (ResolutionView.this.outOfDate) {
                    ResolutionView.this.executeAnalysis();
                }
            } else if (part instanceof IEditorPart && (file = ResourceUtil.getFile((IEditorInput)(editorInput = ((IEditorPart)part).getEditorInput()))) != null && (location = file.getLocation()) != null && (loader = ResolutionView.this.getLoaderForFile(location.toFile())) != null) {
                ResolutionView.this.setLoaders(Collections.singleton(loader));
                if (ResolutionView.this.getSite().getPage().isPartVisible((IWorkbenchPart)ResolutionView.this)) {
                    ResolutionView.this.executeAnalysis();
                } else {
                    ResolutionView.this.outOfDate = true;
                }
            }
        }
    };

    public ResolutionView() {
        this.filteredCapabilityNamespaces = Sets.of((Object)"osgi.identity", (Object)"osgi.wiring.host");
        this.loaders = Collections.emptySet();
    }

    private boolean setLoaders(Set<CapReqLoader> newLoaders) {
        boolean swap;
        Set<CapReqLoader> oldLoaders = this.loaders;
        boolean bl = swap = !oldLoaders.equals(newLoaders);
        if (swap) {
            this.loaders = newLoaders;
        }
        for (CapReqLoader l : swap ? oldLoaders : newLoaders) {
            IO.close((Closeable)l);
        }
        return swap;
    }

    private CapReqLoader getLoaderForFile(File file) {
        if (Strings.endsWithIgnoreCase((String)file.getName(), (String)".bnd")) {
            return new BndFileCapReqLoader(file);
        }
        if (Strings.endsWithIgnoreCase((String)file.getName(), (String)".jar")) {
            return new JarFileCapReqLoader(file);
        }
        if (Strings.endsWithIgnoreCase((String)file.getName(), (String)".mf")) {
            return new ManifestCapReqLoader(file);
        }
        return null;
    }

    public void createPartControl(Composite parent) {
        this.display = parent.getDisplay();
        SashForm splitPanel = new SashForm(parent, 256);
        splitPanel.setLayout((Layout)new FillLayout());
        Composite reqsPanel = new Composite((Composite)splitPanel, 0);
        reqsPanel.setBackground(parent.getBackground());
        GridLayout reqsLayout = new GridLayout(1, false);
        reqsLayout.marginWidth = 0;
        reqsLayout.marginHeight = 0;
        reqsLayout.verticalSpacing = 2;
        reqsPanel.setLayout((Layout)reqsLayout);
        this.reqsFilterPart.createControl(reqsPanel, 5, 5);
        this.reqsFilterPart.setHint(SEARCHSTRING_HINT);
        this.reqsFilterPart.addPropertyChangeListener(event -> {
            String filter = (String)event.getNewValue();
            this.updateReqsFilter(filter);
        });
        this.reqsLabel = new Label(reqsPanel, 0);
        this.reqsLabel.setText("Requirements:");
        this.setContentDescription("Select on one or more resources to see their requirements and capabilities.");
        this.reqsTree = new Tree(reqsPanel, 67586);
        this.reqsTree.setHeaderVisible(false);
        this.reqsTree.setLinesVisible(false);
        this.reqsTree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.reqsViewer = new TreeViewer(this.reqsTree);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.reqsViewer);
        this.reqsViewer.setLabelProvider((IBaseLabelProvider)new RequirementWrapperLabelProvider(true));
        this.reqsContentProvider = new CapReqMapContentProvider();
        this.reqsViewer.setContentProvider((IContentProvider)this.reqsContentProvider);
        this.reqsViewer.addDoubleClickListener(event -> this.handleReqsViewerDoubleClickEvent(event));
        this.reqsViewer.getControl().addKeyListener((KeyListener)this.createCopyToClipboardAdapter((StructuredViewer)this.reqsViewer, (selection, clipboardContent) -> this.reqsCopyToClipboard((IStructuredSelection)selection, (RequirementWrapperLabelProvider)this.reqsViewer.getLabelProvider(), (StringBuilder)clipboardContent)));
        Composite capsPanel = new Composite((Composite)splitPanel, 0);
        capsPanel.setBackground(parent.getBackground());
        GridLayout capsLayout = new GridLayout(1, false);
        capsLayout.marginWidth = 0;
        capsLayout.marginHeight = 0;
        capsLayout.verticalSpacing = 2;
        capsPanel.setLayout((Layout)capsLayout);
        this.capsFilterPart.createControl(capsPanel, 5, 5);
        this.capsFilterPart.setHint(SEARCHSTRING_HINT);
        this.capsFilterPart.addPropertyChangeListener(event -> {
            String filter = (String)event.getNewValue();
            this.updateCapsFilter(filter);
        });
        this.capsLabel = new Label(capsPanel, 0);
        this.capsLabel.setText("Capabilities:");
        this.capsTable = new Table(capsPanel, 67586);
        this.capsTable.setHeaderVisible(false);
        this.capsTable.setLinesVisible(false);
        this.capsTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.capsViewer = new TableViewer(this.capsTable);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.capsViewer);
        this.capsViewer.setLabelProvider((IBaseLabelProvider)new CapabilityLabelProvider(true));
        this.capsContentProvider = new CapReqMapContentProvider();
        this.capsViewer.setContentProvider((IContentProvider)this.capsContentProvider);
        this.capsViewer.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                return !ResolutionView.this.filteredCapabilityNamespaces.contains(((Capability)element).getNamespace());
            }
        }});
        this.filterShowCapsProblems = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof Capability) {
                    Capability cap = (Capability)element;
                    return ResolutionView.this.duplicateCapabilitiesWithDifferentHashes.contains(cap);
                }
                return false;
            }
        };
        this.capsViewer.addDoubleClickListener(event -> this.handleCapsViewerDoubleClickEvent(event));
        this.capsViewer.getTable().addKeyListener((KeyListener)this.createCopyToClipboardAdapter((StructuredViewer)this.capsViewer, (selection1, clipboardContent1) -> this.capsCopyToClipboard((IStructuredSelection)selection1, (CapabilityLabelProvider)this.capsViewer.getLabelProvider(), (StringBuilder)clipboardContent1)));
        this.hideSelfImportsFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof RequirementWrapper) {
                    RequirementWrapper rw = (RequirementWrapper)element;
                    boolean resolved = rw.resolved | rw.java;
                    return !resolved;
                }
                return true;
            }
        };
        this.hideOptionalRequirements = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof RequirementWrapper) {
                    RequirementWrapper rw = (RequirementWrapper)element;
                    return !rw.isOptional();
                }
                return true;
            }
        };
        this.reqsViewer.addDragSupport(3, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new LocalTransferDragListener((Viewer)this.reqsViewer));
        this.capsViewer.addDragSupport(3, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new LocalTransferDragListener((Viewer)this.capsViewer));
        this.reqsViewer.addOpenListener(this::openEditor);
        this.fillActionBars();
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this);
        this.getSite().getPage().addPartListener(this.partAdapter);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        IWorkbenchPart activePart = this.getSite().getPage().getActivePart();
        ISelection activeSelection = this.getSite().getWorkbenchWindow().getSelectionService().getSelection();
        this.selectionChanged(activePart, activeSelection);
    }

    private void openEditor(OpenEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        for (Object item : selection) {
            if (!(item instanceof Clazz)) continue;
            Clazz clazz = (Clazz)item;
            String className = clazz.getFQN();
            IType type = null;
            if (!this.loaders.isEmpty()) {
                IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
                block6: for (CapReqLoader loader : this.loaders) {
                    IFile[] wsfiles;
                    if (!(loader instanceof BndBuilderCapReqLoader)) continue;
                    File loaderFile = ((BndBuilderCapReqLoader)loader).getFile();
                    IFile[] iFileArray = wsfiles = wsroot.findFilesForLocationURI(loaderFile.toURI());
                    int n = wsfiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFile wsfile = iFileArray[n2];
                        IJavaProject javaProject = JavaCore.create((IProject)wsfile.getProject());
                        try {
                            type = javaProject.findType(className);
                            if (type != null) {
                                continue block6;
                            }
                        }
                        catch (JavaModelException e1) {
                            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"", (IStatus)new Status(4, PLUGIN_ID, 0, MessageFormat.format("Error opening Java class '{0}'.", className), (Throwable)e1));
                        }
                        ++n2;
                    }
                }
            }
            try {
                if (type == null) continue;
                JavaUI.openInEditor(type, (boolean)true, (boolean)true);
            }
            catch (PartInitException e2) {
                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"", (IStatus)new Status(4, PLUGIN_ID, 0, MessageFormat.format("Error opening Java editor for class '{0}'.", className), (Throwable)e2));
            }
            catch (JavaModelException e3) {
                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"", (IStatus)new Status(4, PLUGIN_ID, 0, MessageFormat.format("Error opening Java class '{0}'.", className), (Throwable)e3));
            }
        }
    }

    void fillActionBars() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add(this.createToggleHideSelfImportsButton());
        toolBarManager.add(this.createToggleHideOptionalReqsFilterButton());
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add(this.createShowProblemCapsAction());
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add(this.createToggleLockInputButton());
        this.doEEActionMenu(toolBarManager);
        toolBarManager.add((IAction)HelpButtons.HELP_BTN_RESOLUTION_VIEW);
    }

    private void doEEActionMenu(IToolBarManager toolBarManager) {
        final MenuManager menuManager = new MenuManager("Java", "resolutionview.java.menu");
        final Action showMenuAction = new Action("Java"){

            public void runWithEvent(Event event) {
                Menu menu = menuManager.createContextMenu((Control)ResolutionView.this.getViewSite().getShell());
                MenuItem[] items = menu.getItems();
                if (items != null && items.length == ResolutionView.this.ees.size()) {
                    menu.setDefaultItem(items[ResolutionView.this.currentEE]);
                }
                Point location = ResolutionView.this.getViewSite().getShell().getDisplay().getCursorLocation();
                menu.setLocation(location.x, location.y);
                menu.setVisible(true);
            }

            public ImageDescriptor getImageDescriptor() {
                return Resources.getImageDescriptor("jcu_obj");
            }
        };
        int n = 0;
        while (n < this.ees.size()) {
            int nn = n;
            EE ee = this.ees.get(n);
            if (ee.getRelease() == 9) {
                this.currentEE = n;
            }
            String name = this.getEEName(ee);
            Action action = new Action(name, nn){
                int index;
                {
                    super($anonymous0);
                    this.index = n;
                }

                public void run() {
                    ResolutionView.this.setEE(this.index);
                    showMenuAction.setToolTipText(ResolutionView.this.getEEName(ResolutionView.this.ees.get(ResolutionView.this.currentEE)));
                }
            };
            menuManager.add((IAction)action);
            ++n;
        }
        showMenuAction.setToolTipText(this.getEEName(this.ees.get(this.currentEE)));
        toolBarManager.add((IAction)showMenuAction);
    }

    private String getEEName(EE ee) {
        return ee == EE.UNKNOWN ? "unknown" : ee.getEEName();
    }

    protected void setEE(int ee) {
        this.currentEE = ee;
        this.executeAnalysis();
    }

    public void setFocus() {
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.getSite().getPage().removePartListener(this.partAdapter);
        this.setLoaders(Collections.emptySet());
        this.duplicateCapabilitiesWithDifferentHashes.clear();
        super.dispose();
    }

    public void setInput(Set<CapReqLoader> sourceLoaders, Map<String, List<Capability>> capabilities, Map<String, List<RequirementWrapper>> requirements) {
        this.setLoaders(sourceLoaders);
        sourceLoaders = this.loaders;
        if (this.reqsTree != null && !this.reqsTree.isDisposed() && this.capsTable != null && !this.capsTable.isDisposed()) {
            String label;
            this.reqsViewer.setInput(requirements);
            this.capsViewer.setInput(capabilities);
            if (!sourceLoaders.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                String delim = "";
                boolean shortLabel = sourceLoaders.size() > 1;
                for (CapReqLoader l : sourceLoaders) {
                    builder.append(delim);
                    builder.append(shortLabel ? l.getShortLabel() : l.getLongLabel());
                    delim = ", ";
                }
                label = builder.toString();
            } else {
                label = "<no input>";
            }
            this.setContentDescription(label);
            this.updateReqsLabel();
            List caps = capabilities.values().stream().flatMap(Collection::stream).toList();
            this.duplicateCapabilitiesWithDifferentHashes = new HashSet<Capability>(ResourceUtils.detectDuplicateCapabilitiesWithDifferentHashes((String)"osgi.wiring.package", caps));
            this.updateCapsLabel();
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            return;
        }
        Set<CapReqLoader> loaders = this.getLoadersFromSelection((IStructuredSelection)selection);
        if (this.setLoaders(loaders)) {
            IWorkbenchPage page = this.getSite().getPage();
            if (page != null && page.isPartVisible((IWorkbenchPart)this)) {
                this.executeAnalysis();
            } else {
                this.outOfDate = true;
            }
        }
    }

    private void updateReqsLabel() {
        this.reqsLabel.setText("Requirements: " + this.reqsViewer.getTree().getItemCount());
        this.reqsLabel.getParent().layout();
    }

    private void updateCapsLabel() {
        Object problemAddition = "";
        if (!this.duplicateCapabilitiesWithDifferentHashes.isEmpty()) {
            int problemCount = 0;
            TableItem[] items = this.capsViewer.getTable().getItems();
            int i = 0;
            while (i < items.length) {
                Capability cap;
                TableItem tableItem = items[i];
                Object data = tableItem.getData();
                if (data instanceof Capability && this.duplicateCapabilitiesWithDifferentHashes.contains(cap = (Capability)data)) {
                    ++problemCount;
                }
                ++i;
            }
            if (problemCount > 0) {
                problemAddition = " Problems: " + problemCount;
            }
        }
        this.capsLabel.setText("Capabilities: " + this.capsViewer.getTable().getItemCount() + (String)problemAddition);
        this.capsLabel.getParent().layout();
    }

    private Set<CapReqLoader> getLoadersFromSelection(IStructuredSelection structSel) {
        LinkedHashSet<CapReqLoader> result = new LinkedHashSet<CapReqLoader>();
        for (Object element : structSel) {
            if (element instanceof Repository) {
                Repository repo = (Repository)element;
                ResourceUtils.getAllResources((Repository)repo).stream().filter(r -> {
                    try {
                        return ResourceUtils.getContentCapabilities((Resource)r) != null;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }).map(ResourceCapReqLoader::new).forEach(result::add);
                continue;
            }
            CapReqLoader loader = this.findLoaderForElement(element);
            if (loader == null) continue;
            result.add(loader);
        }
        return result;
    }

    protected CapReqLoader findLoaderForElement(Object element) {
        IPath location;
        CapReqLoader loader = (CapReqLoader)Adapters.adapt((Object)element, CapReqLoader.class);
        if (loader != null) {
            return loader;
        }
        ResourceProvider resourceProvider = (ResourceProvider)Adapters.adapt((Object)element, ResourceProvider.class);
        if (resourceProvider != null) {
            return new ResourceCapReqLoader(resourceProvider.getResource());
        }
        Resource resource = (Resource)Adapters.adapt((Object)element, Resource.class);
        if (resource != null) {
            return new ResourceCapReqLoader(resource);
        }
        File file = (File)Adapters.adapt((Object)element, File.class);
        if (file != null) {
            return this.getLoaderForFile(file);
        }
        IResource eclipseResource = (IResource)Adapters.adapt((Object)element, IResource.class);
        if (eclipseResource != null && (location = eclipseResource.getLocation()) != null) {
            return this.getLoaderForFile(location.toFile());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeAnalysis() {
        if (this.inputLocked) {
            return;
        }
        this.outOfDate = false;
        ResolutionView resolutionView = this;
        synchronized (resolutionView) {
            Job oldJob = this.analysisJob;
            if (oldJob != null && oldJob.getState() != 0) {
                oldJob.cancel();
            }
            if (!this.loaders.isEmpty()) {
                final AnalyseBundleResolutionJob job = new AnalyseBundleResolutionJob("importExportAnalysis", this.loaders, this.ees.get(this.currentEE));
                job.setSystem(true);
                job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void aboutToRun(IJobChangeEvent event) {
                        if (ResolutionView.this.display != null && !ResolutionView.this.display.isDisposed()) {
                            Runnable update = () -> ResolutionView.this.setContentDescription("Working...");
                            if (ResolutionView.this.display.getThread() == Thread.currentThread()) {
                                update.run();
                            } else {
                                ResolutionView.this.display.asyncExec(update);
                            }
                        }
                    }

                    public void done(IJobChangeEvent event) {
                        IStatus result = job.getResult();
                        if (result != null && result.isOK() && ResolutionView.this.display != null && !ResolutionView.this.display.isDisposed()) {
                            ResolutionView.this.display.asyncExec(() -> ResolutionView.this.setInput(ResolutionView.this.loaders, job.getCapabilities(), job.getRequirements()));
                        }
                    }
                });
                this.analysisJob = job;
                this.analysisJob.schedule(500L);
            } else {
                this.analysisJob = null;
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (!this.loaders.isEmpty()) {
            IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
            block0: for (CapReqLoader loader : this.loaders) {
                IFile[] wsfiles;
                if (!(loader instanceof BndBuilderCapReqLoader)) continue;
                File file = ((BndBuilderCapReqLoader)loader).getFile();
                IFile[] iFileArray = wsfiles = wsroot.findFilesForLocationURI(file.toURI());
                int n = wsfiles.length;
                int n2 = 0;
                while (n2 < n) {
                    IFile wsfile = iFileArray[n2];
                    if (event.getDelta().findMember(wsfile.getFullPath()) != null) {
                        this.executeAnalysis();
                        continue block0;
                    }
                    ++n2;
                }
            }
        }
    }

    private void handleReqsViewerDoubleClickEvent(DoubleClickEvent event) {
        IStructuredSelection selection;
        Object element;
        if (!event.getSelection().isEmpty() && (element = (selection = (IStructuredSelection)event.getSelection()).getFirstElement()) instanceof RequirementWrapper) {
            RequirementWrapper rw = (RequirementWrapper)element;
            Requirement req = rw.requirement;
            this.eventBroker.post(ViewEventTopics.REPOSITORIESVIEW_OPEN_ADVANCED_SEARCH.topic(), (Object)req);
        }
    }

    private void handleCapsViewerDoubleClickEvent(DoubleClickEvent event) {
        IStructuredSelection selection;
        Object element;
        if (!event.getSelection().isEmpty() && (element = (selection = (IStructuredSelection)event.getSelection()).getFirstElement()) instanceof Capability) {
            Capability cap = (Capability)element;
            RequirementImpl req = CapReqBuilder.createRequirementFromCapability((Capability)cap, name -> !name.equals("bundle-symbolic-name") && !name.equals("bundle-version") && !name.equals("bnd.hashes")).buildSyntheticRequirement();
            this.eventBroker.post(ViewEventTopics.REPOSITORIESVIEW_OPEN_ADVANCED_SEARCH.topic(), (Object)req);
        }
    }

    private KeyAdapter createCopyToClipboardAdapter(final StructuredViewer viewer, final BiConsumer<IStructuredSelection, StringBuilder> clipboardContentExtractor) {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & SWT.MOD1) == SWT.MOD1 && e.keyCode == 99) {
                    IStructuredSelection selection = viewer.getStructuredSelection();
                    StringBuilder clipboardString = new StringBuilder();
                    clipboardContentExtractor.accept(selection, clipboardString);
                    if (clipboardString.length() > 0) {
                        Clipboard clipboard = new Clipboard(Display.getCurrent());
                        TextTransfer textTransfer = TextTransfer.getInstance();
                        clipboard.setContents(new Object[]{clipboardString.toString()}, new Transfer[]{textTransfer});
                        clipboard.dispose();
                    }
                }
            }
        };
    }

    private void reqsCopyToClipboard(IStructuredSelection selection, RequirementWrapperLabelProvider lp, StringBuilder clipboardContent) {
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            if (element instanceof RequirementWrapper) {
                RequirementWrapper reqWrapper = (RequirementWrapper)element;
                clipboardContent.append(lp.getToolTipText(reqWrapper));
                if (!iterator.hasNext()) continue;
                clipboardContent.append(System.lineSeparator());
                continue;
            }
            clipboardContent.append(element.toString());
            if (!iterator.hasNext()) continue;
            clipboardContent.append(System.lineSeparator());
        }
    }

    private void capsCopyToClipboard(IStructuredSelection selection, CapabilityLabelProvider lp, StringBuilder clipboardContent) {
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            if (element instanceof Capability) {
                Capability cap = (Capability)element;
                clipboardContent.append(lp.getToolTipText(cap));
                if (iterator.hasNext()) {
                    clipboardContent.append(System.lineSeparator());
                }
            } else {
                clipboardContent.append(element.toString());
            }
            if (!iterator.hasNext()) continue;
            clipboardContent.append(System.lineSeparator());
        }
    }

    private void updateReqsFilter(String filterString) {
        this.reqsContentProvider.setFilter(filterString);
        this.reqsViewer.refresh();
        this.updateReqsLabel();
        if (filterString != null) {
            this.reqsViewer.expandToLevel(1);
        }
    }

    private void updateCapsFilter(String filterString) {
        this.capsContentProvider.setFilter(filterString);
        this.capsViewer.refresh();
        this.updateCapsLabel();
    }

    private IAction createShowProblemCapsAction() {
        final String tooltipTextUnlocked = "Click to detect capabilities containing packages that have the same name but differ in the contained classes.";
        Action toggleShowProblemCaps = new Action("showProblemCaps", 2){

            public void runWithEvent(Event event) {
                if (this.isChecked()) {
                    ResolutionView.this.capsViewer.addFilter(ResolutionView.this.filterShowCapsProblems);
                    this.setToolTipText("Showing capabilities containing packages that have the same name but differ in the contained classes.");
                } else {
                    ResolutionView.this.capsViewer.removeFilter(ResolutionView.this.filterShowCapsProblems);
                    this.setToolTipText(tooltipTextUnlocked);
                }
                ResolutionView.this.updateCapsLabel();
            }
        };
        toggleShowProblemCaps.setChecked(false);
        toggleShowProblemCaps.setImageDescriptor(Resources.getImageDescriptor("/icons/warning_obj.svg"));
        toggleShowProblemCaps.setToolTipText(tooltipTextUnlocked);
        return toggleShowProblemCaps;
    }

    private IAction createToggleLockInputButton() {
        final String toolTipTextUnchecked = "Lock to current selection";
        Action toggleLockInput = new Action("lockInput", 2){

            public void runWithEvent(Event event) {
                ResolutionView.this.inputLocked = this.isChecked();
                if (!ResolutionView.this.inputLocked) {
                    this.setToolTipText(toolTipTextUnchecked);
                    ResolutionView.this.executeAnalysis();
                } else {
                    this.setToolTipText("Current selection is locked");
                }
            }
        };
        toggleLockInput.setChecked(false);
        toggleLockInput.setImageDescriptor(Resources.getImageDescriptor("lockedstate.svg"));
        toggleLockInput.setToolTipText(toolTipTextUnchecked);
        return toggleLockInput;
    }

    private IAction createToggleHideSelfImportsButton() {
        final String toolTipTextShowAll = "Showing all requirements.";
        final String toolTipTextHideSelfImports = "Hiding resolved (including self-imported) requirements.\n\nRequirements that are resolved (exported and imported) within the set of selected bundles are hidden. Click to show all requirements.";
        Action toggleShowSelfImports = new Action("showSelfImports", 2){

            public void runWithEvent(Event event) {
                if (this.isChecked()) {
                    ResolutionView.this.reqsViewer.addFilter(ResolutionView.this.hideSelfImportsFilter);
                    this.setToolTipText(toolTipTextHideSelfImports);
                } else {
                    ResolutionView.this.reqsViewer.removeFilter(ResolutionView.this.hideSelfImportsFilter);
                    this.setToolTipText(toolTipTextShowAll);
                }
                ResolutionView.this.updateReqsLabel();
            }
        };
        toggleShowSelfImports.setChecked(false);
        toggleShowSelfImports.setImageDescriptor(Resources.getImageDescriptor("/icons/bundle-importer-exporter.svg"));
        toggleShowSelfImports.setToolTipText(toolTipTextShowAll);
        return toggleShowSelfImports;
    }

    private IAction createToggleHideOptionalReqsFilterButton() {
        final String toggleShowShowUnresolvedReqsFilterUnchecked = "Optional requirements are included. Click to hide optional requirements.";
        Action toggleShowShowUnresolvedReqsFilter = new Action("hideOptionalReqs", 2){

            public void runWithEvent(Event event) {
                if (this.isChecked()) {
                    ResolutionView.this.reqsViewer.addFilter(ResolutionView.this.hideOptionalRequirements);
                    this.setToolTipText("Optional requirements are now hidden");
                } else {
                    ResolutionView.this.reqsViewer.removeFilter(ResolutionView.this.hideOptionalRequirements);
                    this.setToolTipText(toggleShowShowUnresolvedReqsFilterUnchecked);
                }
                ResolutionView.this.updateReqsLabel();
            }
        };
        toggleShowShowUnresolvedReqsFilter.setChecked(false);
        toggleShowShowUnresolvedReqsFilter.setImageDescriptor(Resources.getImageDescriptor("/icons/excludeMode_filter.svg"));
        toggleShowShowUnresolvedReqsFilter.setToolTipText(toggleShowShowUnresolvedReqsFilterUnchecked);
        return toggleShowShowUnresolvedReqsFilter;
    }

    static class LocalTransferDragListener
    implements DragSourceListener {
        private final Viewer viewer;

        public LocalTransferDragListener(Viewer viewer) {
            this.viewer = viewer;
        }

        public void dragStart(DragSourceEvent event) {
        }

        public void dragSetData(DragSourceEvent event) {
            LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
            if (transfer.isSupportedType(event.dataType)) {
                transfer.setSelection(this.viewer.getSelection());
            }
        }

        public void dragFinished(DragSourceEvent event) {
        }
    }
}

