/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.registry.internal;

import java.lang.reflect.Method;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.equinox.http.registry.internal.DefaultRegistryHttpContext;
import org.eclipse.equinox.http.registry.internal.FilterManager;
import org.eclipse.equinox.http.registry.internal.HttpContextManager;
import org.eclipse.equinox.http.registry.internal.ResourceManager;
import org.eclipse.equinox.http.registry.internal.ServletManager;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.packageadmin.PackageAdmin;

public class HttpRegistryManager {
    private final HttpContextManager httpContextManager;
    private final ServletManager servletManager;
    private final FilterManager filterManager;
    private final ResourceManager resourceManager;
    private final HttpService httpService;
    private final PackageAdmin packageAdmin;
    private final Map<String, HttpContextContribution> contexts = new HashMap<String, HttpContextContribution>();
    private final Map<String, FilterContribution> filters = new HashMap<String, FilterContribution>();
    private final Map<String, ServletContribution> servlets = new HashMap<String, ServletContribution>();
    private final Map<String, ResourcesContribution> resources = new HashMap<String, ResourcesContribution>();
    private final Set<String> registered = new HashSet<String>();

    public HttpRegistryManager(ServiceReference<?> reference, HttpService httpService, PackageAdmin packageAdmin, IExtensionRegistry registry) {
        this.httpService = httpService;
        this.packageAdmin = packageAdmin;
        this.httpContextManager = new HttpContextManager(this, registry);
        this.filterManager = new FilterManager(this, reference, registry);
        this.servletManager = new ServletManager(this, reference, registry);
        this.resourceManager = new ResourceManager(this, reference, registry);
    }

    public void start() {
        this.httpContextManager.start();
        this.filterManager.start();
        this.servletManager.start();
        this.resourceManager.start();
    }

    public void stop() {
        this.resourceManager.stop();
        this.servletManager.stop();
        this.filterManager.stop();
        this.httpContextManager.stop();
    }

    public synchronized boolean addResourcesContribution(String alias, String baseName, String httpContextId, IContributor contributor) {
        if (this.resources.containsKey(alias) || this.servlets.containsKey(alias)) {
            System.err.println("ERROR: Duplicate alias. Failed to register resource for [alias=\"" + alias + "\", contributor=\"" + String.valueOf(contributor) + "\"]");
            return false;
        }
        ResourcesContribution contribution = new ResourcesContribution(alias, baseName, httpContextId, contributor);
        this.resources.put(alias, contribution);
        if (httpContextId == null || this.contexts.containsKey(httpContextId)) {
            this.registerResources(contribution);
        }
        return true;
    }

    public synchronized boolean addServletContribution(String alias, Servlet servlet, Dictionary<?, ?> initparams, String httpContextId, IContributor contributor) {
        if (this.resources.containsKey(alias) || this.servlets.containsKey(alias)) {
            System.err.println("ERROR: Duplicate alias. Failed to register servlet for [alias=\"" + alias + "\", contributor=\"" + String.valueOf(contributor) + "\"]");
            return false;
        }
        ServletContribution contribution = new ServletContribution(alias, servlet, initparams, httpContextId, contributor);
        this.servlets.put(alias, contribution);
        if (httpContextId == null || this.contexts.containsKey(httpContextId)) {
            this.registerServlet(contribution);
        }
        return true;
    }

    public synchronized void removeContribution(String alias) {
        this.resources.remove(alias);
        this.servlets.remove(alias);
        this.unregister(alias);
    }

    public synchronized boolean addFilterContribution(String alias, Filter filter, Dictionary<?, ?> initparams, String httpContextId, IContributor contributor) {
        FilterContribution contribution = new FilterContribution(alias, filter, initparams, httpContextId, contributor);
        return this.registerFilter(contribution);
    }

    public synchronized void removeFilterContribution(Filter filter) {
        this.unregisterFilter(filter);
    }

    public synchronized HttpContext getHttpContext(String httpContextId, Bundle bundle) {
        Bundle httpContextBundle;
        AdminPermission resourcePermission;
        HttpContextContribution contribution = this.contexts.get(httpContextId);
        if (contribution == null) {
            return null;
        }
        if (System.getSecurityManager() != null && !bundle.hasPermission((Object)(resourcePermission = new AdminPermission(httpContextBundle = this.getBundle(contribution.contributor), "resource")))) {
            return null;
        }
        return contribution.context;
    }

    public synchronized boolean addHttpContextContribution(String httpContextId, HttpContext context, IContributor contributor) {
        if (this.contexts.containsKey(httpContextId)) {
            System.err.println("ERROR: Duplicate HttpContextId. Failed to register HttpContext for [httpContextId=\"" + httpContextId + "\", contributor=\"" + String.valueOf(contributor) + "\"]");
            return false;
        }
        this.contexts.put(httpContextId, new HttpContextContribution(context, contributor));
        for (FilterContribution filterContribution : this.filters.values()) {
            if (!httpContextId.equals(filterContribution.httpContextId)) continue;
            this.registerFilter(filterContribution);
        }
        for (ResourcesContribution resourcesContribution : this.resources.values()) {
            if (!httpContextId.equals(resourcesContribution.httpContextId)) continue;
            this.registerResources(resourcesContribution);
        }
        for (ServletContribution servletContribution : this.servlets.values()) {
            if (!httpContextId.equals(servletContribution.httpContextId)) continue;
            this.registerServlet(servletContribution);
        }
        return true;
    }

    public synchronized void removeHttpContextContribution(String httpContextId) {
        if (this.contexts.remove(httpContextId) != null) {
            for (ResourcesContribution resourcesContribution : this.resources.values()) {
                if (!httpContextId.equals(resourcesContribution.httpContextId)) continue;
                this.unregister(resourcesContribution.alias);
            }
            for (ServletContribution servletContribution : this.servlets.values()) {
                if (!httpContextId.equals(servletContribution.httpContextId)) continue;
                this.unregister(servletContribution.alias);
            }
        }
    }

    public DefaultRegistryHttpContext createDefaultRegistryHttpContext() {
        try {
            HttpContext defaultContext = this.httpService.createDefaultHttpContext();
            return new DefaultRegistryHttpContext(defaultContext);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public Bundle getBundle(IContributor contributor) {
        return this.getBundle(contributor.getName());
    }

    public Bundle getBundle(String symbolicName) {
        Bundle[] bundles = this.packageAdmin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if ((bundle.getState() & 3) == 0) {
                return bundle;
            }
            ++n2;
        }
        return null;
    }

    private void registerResources(ResourcesContribution contribution) {
        HttpContext context = this.getHttpContext(contribution.httpContextId, contribution.contributor);
        if (context == null) {
            return;
        }
        try {
            this.httpService.registerResources(contribution.alias, contribution.baseName, context);
            this.registered.add(contribution.alias);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void registerServlet(ServletContribution contribution) {
        HttpContext context = this.getHttpContext(contribution.httpContextId, contribution.contributor);
        if (context == null) {
            return;
        }
        try {
            this.httpService.registerServlet(contribution.alias, contribution.servlet, contribution.initparams, context);
            this.registered.add(contribution.alias);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void unregister(String alias) {
        if (this.registered.remove(alias)) {
            try {
                this.httpService.unregister(alias);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private boolean registerFilter(FilterContribution contribution) {
        HttpContext context = this.getHttpContext(contribution.httpContextId, contribution.contributor);
        if (context == null) {
            return false;
        }
        Method registerFilterMethod = null;
        try {
            registerFilterMethod = this.httpService.getClass().getMethod("registerFilter", String.class, Filter.class, Dictionary.class, HttpContext.class);
            registerFilterMethod.invoke((Object)this.httpService, contribution.alias, contribution.filter, contribution.initparams, context);
            return true;
        }
        catch (NoSuchMethodException e) {
            try {
                registerFilterMethod = this.httpService.getClass().getMethod("registerFilter", Filter.class, String[].class, String[].class, Dictionary.class, HttpContext.class);
                registerFilterMethod.invoke((Object)this.httpService, contribution.filter, new String[]{contribution.alias}, null, contribution.initparams, context);
                return true;
            }
            catch (Throwable throwable) {
                e.printStackTrace();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return false;
    }

    private void unregisterFilter(Filter filter) {
        try {
            Method unregisterFilterMethod = this.httpService.getClass().getMethod("unregisterFilter", Filter.class);
            unregisterFilterMethod.invoke((Object)this.httpService, filter);
        }
        catch (NoSuchMethodException unregisterFilterMethod) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private HttpContext getHttpContext(String httpContextId, IContributor contributor) {
        Bundle httpContextBundle;
        AdminPermission resourcePermission;
        Bundle contributorBundle;
        if (httpContextId == null) {
            DefaultRegistryHttpContext defaultContext = this.createDefaultRegistryHttpContext();
            if (defaultContext == null) {
                return null;
            }
            defaultContext.addResourceMapping(this.getBundle(contributor), null);
            return defaultContext;
        }
        HttpContextContribution contribution = this.contexts.get(httpContextId);
        if (System.getSecurityManager() != null && !(contributorBundle = this.getBundle(contributor)).hasPermission((Object)(resourcePermission = new AdminPermission(httpContextBundle = this.getBundle(contribution.contributor), "resource")))) {
            return null;
        }
        return contribution.context;
    }

    class FilterContribution {
        String alias;
        Filter filter;
        Dictionary<?, ?> initparams;
        String httpContextId;
        IContributor contributor;

        public FilterContribution(String alias, Filter filter, Dictionary<?, ?> initparams, String httpContextId, IContributor contributor) {
            this.alias = alias;
            this.filter = filter;
            this.initparams = initparams;
            this.httpContextId = httpContextId;
            this.contributor = contributor;
        }
    }

    class HttpContextContribution {
        HttpContext context;
        IContributor contributor;

        public HttpContextContribution(HttpContext context, IContributor contributor) {
            this.context = context;
            this.contributor = contributor;
        }
    }

    class ResourcesContribution {
        String alias;
        String baseName;
        String httpContextId;
        IContributor contributor;

        public ResourcesContribution(String alias, String baseName, String httpContextId, IContributor contributor) {
            this.alias = alias;
            this.baseName = baseName;
            this.httpContextId = httpContextId;
            this.contributor = contributor;
        }
    }

    class ServletContribution {
        String alias;
        Servlet servlet;
        Dictionary<?, ?> initparams;
        String httpContextId;
        IContributor contributor;

        public ServletContribution(String alias, Servlet servlet, Dictionary<?, ?> initparams, String httpContextId, IContributor contributor) {
            this.alias = alias;
            this.servlet = servlet;
            this.initparams = initparams;
            this.httpContextId = httpContextId;
            this.contributor = contributor;
        }
    }
}

