/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.monitors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.ui.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.core.model.GroupedStackFrame;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;
import org.eclipse.jdt.internal.debug.ui.StackFramePresentationProvider;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaElementContentProvider;
import org.eclipse.jdt.internal.debug.ui.monitors.NoMonitorInformationElement;

public class JavaThreadContentProvider
extends JavaElementContentProvider {
    private StackFramePresentationProvider stackFrameProvider;

    protected int getChildCount(Object element, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        if (element instanceof GroupedStackFrame) {
            GroupedStackFrame groupedFrame = (GroupedStackFrame)element;
            return groupedFrame.getFrameCount();
        }
        IJavaThread thread = (IJavaThread)element;
        if (!thread.isSuspended()) {
            return 0;
        }
        int childCount = this.getFrameCount(thread);
        if (JavaThreadContentProvider.isDisplayMonitors()) {
            if (((IJavaDebugTarget)thread.getDebugTarget()).supportsMonitorInformation()) {
                childCount += thread.getOwnedMonitors().length;
                if (thread.getContendedMonitor() != null) {
                    ++childCount;
                }
            } else {
                ++childCount;
            }
        }
        return childCount;
    }

    private int getFrameCount(IJavaThread thread) throws DebugException {
        if (this.getStackFrameProvider().isCollapseStackFrames()) {
            return this.getStackFrames(thread).size();
        }
        return thread.getFrameCount();
    }

    protected Object[] getChildren(Object parent, int index, int length, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        if (parent instanceof GroupedStackFrame) {
            GroupedStackFrame groupedFrame = (GroupedStackFrame)parent;
            return groupedFrame.getFramesAsArray(index, length);
        }
        IJavaThread thread = (IJavaThread)parent;
        if (!thread.isSuspended()) {
            return EMPTY;
        }
        return this.getElements(this.getChildren(thread), index, length);
    }

    protected Object[] getChildren(IJavaThread thread) {
        try {
            JDIThread jThread;
            if (thread instanceof JDIThread && !(jThread = (JDIThread)thread).getDebugTarget().isSuspended() && jThread.isSuspendVoteInProgress()) {
                return EMPTY;
            }
            List<IDebugElement> frames = this.getStackFrames(thread);
            if (!JavaThreadContentProvider.isDisplayMonitors()) {
                return frames.toArray();
            }
            if (((IJavaDebugTarget)thread.getDebugTarget()).supportsMonitorInformation()) {
                IDebugElement[] ownedMonitors = JavaDebugUtils.getOwnedMonitors((IThread)thread);
                IDebugElement contendedMonitor = JavaDebugUtils.getContendedMonitor((IThread)thread);
                if (contendedMonitor != null) {
                    frames.add(0, contendedMonitor);
                }
                if (ownedMonitors.length > 0) {
                    frames.addAll(0, Arrays.asList(ownedMonitors));
                }
            } else {
                frames.add(0, (IDebugElement)new NoMonitorInformationElement(thread.getDebugTarget()));
            }
            return frames.toArray();
        }
        catch (DebugException e) {
            return EMPTY;
        }
    }

    private List<IDebugElement> getStackFrames(IJavaThread thread) throws DebugException {
        IStackFrame[] frames = thread.getStackFrames();
        StackFramePresentationProvider stackFrameProvider = this.getStackFrameProvider();
        ArrayList<IDebugElement> result = new ArrayList<IDebugElement>(frames.length);
        if (!stackFrameProvider.isCollapseStackFrames()) {
            result.addAll(Arrays.asList(frames));
            return result;
        }
        GroupedStackFrame lastGroupping = null;
        boolean first = true;
        IStackFrame[] iStackFrameArray = frames;
        int n = frames.length;
        int n2 = 0;
        while (n2 < n) {
            IStackFrame frame = iStackFrameArray[n2];
            if (first) {
                result.add((IDebugElement)frame);
                first = false;
            } else if (frame instanceof JDIStackFrame) {
                JDIStackFrame javaFrame = (JDIStackFrame)frame;
                IJavaStackFrame.Category category = javaFrame.getCategory();
                if (category == null || !category.hideWhenCollapse()) {
                    if (lastGroupping != null) {
                        if (lastGroupping.getFrameCount() > 1) {
                            result.add((IDebugElement)lastGroupping);
                        } else {
                            result.add((IDebugElement)lastGroupping.getTopMostFrame());
                        }
                    }
                    result.add((IDebugElement)javaFrame);
                    lastGroupping = null;
                } else {
                    if (lastGroupping == null) {
                        lastGroupping = new GroupedStackFrame(javaFrame.getJavaDebugTarget());
                    }
                    lastGroupping.add((IJavaStackFrame)javaFrame);
                }
            } else {
                result.add((IDebugElement)frame);
            }
            ++n2;
        }
        if (lastGroupping != null) {
            result.add((IDebugElement)lastGroupping);
        }
        return result;
    }

    protected boolean hasChildren(Object element, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        JDIThread jThread;
        if (element instanceof JDIThread && !(jThread = (JDIThread)element).getDebugTarget().isSuspended() && jThread.isSuspendVoteInProgress()) {
            return false;
        }
        if (element instanceof GroupedStackFrame) {
            GroupedStackFrame groupedFrame = (GroupedStackFrame)element;
            return groupedFrame.getFrameCount() > 0;
        }
        return ((IJavaThread)element).hasStackFrames() || JavaThreadContentProvider.isDisplayMonitors() && ((IJavaThread)element).hasOwnedMonitors();
    }

    protected ISchedulingRule getRule(IChildrenCountUpdate[] updates) {
        return this.getThreadRule((IViewerUpdate[])updates);
    }

    protected ISchedulingRule getRule(IChildrenUpdate[] updates) {
        return this.getThreadRule((IViewerUpdate[])updates);
    }

    protected ISchedulingRule getRule(IHasChildrenUpdate[] updates) {
        return this.getThreadRule((IViewerUpdate[])updates);
    }

    private ISchedulingRule getThreadRule(IViewerUpdate[] updates) {
        Object element;
        if (updates.length > 0 && (element = updates[0].getElement()) instanceof JDIThread) {
            return ((JDIThread)element).getThreadRule();
        }
        return null;
    }

    private synchronized StackFramePresentationProvider getStackFrameProvider() {
        if (this.stackFrameProvider == null) {
            this.stackFrameProvider = new StackFramePresentationProvider();
        }
        return this.stackFrameProvider;
    }
}

