/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.discovery.wizards;

import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.internal.p2.discovery.AbstractCatalogSource;
import org.eclipse.equinox.internal.p2.discovery.model.Overview;
import org.eclipse.equinox.internal.p2.ui.discovery.util.GradientToolTip;
import org.eclipse.equinox.internal.p2.ui.discovery.util.WorkbenchUtil;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.Messages;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;

class OverviewToolTip
extends GradientToolTip {
    private final Overview overview;
    private final AbstractCatalogSource source;
    private final Control parent;
    private final Image leftImage;

    public OverviewToolTip(Control control, AbstractCatalogSource source, Overview overview, Image leftImage) {
        super(control, 1, true);
        Assert.isNotNull((Object)source);
        Assert.isNotNull((Object)overview);
        this.parent = control;
        this.source = source;
        this.overview = overview;
        this.leftImage = leftImage;
        this.setHideOnMouseDown(false);
    }

    @Override
    protected Composite createToolTipArea(Event event, Composite parentComposite) {
        GridLayoutFactory.fillDefaults().applyTo(parentComposite);
        Composite container = new Composite(parentComposite, 0);
        container.setBackground(null);
        Image image = null;
        if (this.overview.getScreenshot() != null && (image = this.computeImage(this.source, this.overview.getScreenshot())) != null) {
            Image fimage = image;
            container.addDisposeListener(e -> fimage.dispose());
        }
        boolean hasLearnMoreLink = this.overview.getUrl() != null && this.overview.getUrl().length() > 0;
        boolean borderWidth = true;
        int fixedImageHeight = 240;
        int fixedImageWidth = 320;
        int heightHint = 242;
        int widthHint = 320;
        int containerWidthHintWithImage = 650;
        int containerWidthHintWithoutImage = 500;
        GridDataFactory.fillDefaults().grab(true, true).hint(image == null ? 500 : 650, -1).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(this.leftImage != null ? 3 : 2).margins(5, 5).spacing(3, 0).applyTo(container);
        if (this.leftImage != null) {
            Label imageLabel = new Label(container, 0);
            imageLabel.setImage(this.leftImage);
            int imageWidthHint = this.leftImage.getBounds().width + 5;
            GridDataFactory.fillDefaults().align(1, 1).hint(imageWidthHint, -1).applyTo((Control)imageLabel);
        }
        String summary = this.overview.getSummary();
        Composite summaryContainer = new Composite(container, 0);
        summaryContainer.setBackground(null);
        GridLayoutFactory.fillDefaults().applyTo(summaryContainer);
        GridDataFactory gridDataFactory = GridDataFactory.fillDefaults().grab(true, true).span(image == null ? 2 : 1, 1);
        if (image != null) {
            gridDataFactory.hint(320, 242);
        }
        gridDataFactory.applyTo((Control)summaryContainer);
        StyledText summaryLabel = new StyledText(summaryContainer, 524360);
        summaryLabel.setText(summary);
        Point size = summaryLabel.computeSize(320, -1);
        if (size.y > 222) {
            summaryLabel.dispose();
            summaryLabel = new StyledText(summaryContainer, 524872);
            summaryLabel.setText(summary);
        }
        summaryLabel.setBackground(null);
        GridDataFactory.fillDefaults().grab(true, true).align(1, 1).applyTo((Control)summaryLabel);
        if (image != null) {
            Composite imageContainer = new Composite(container, 2048);
            GridLayoutFactory.fillDefaults().applyTo(imageContainer);
            GridDataFactory.fillDefaults().grab(false, false).align(0x1000000, 1).hint(322, 242).applyTo((Control)imageContainer);
            Label imageLabel = new Label(imageContainer, 0);
            GridDataFactory.fillDefaults().hint(320, 240).indent(1, 1).applyTo((Control)imageLabel);
            imageLabel.setImage(image);
            imageLabel.setBackground(null);
            imageLabel.setSize(320, 240);
            imageContainer.setBackground(parentComposite.getDisplay().getSystemColor(2));
        }
        if (hasLearnMoreLink) {
            Link link = new Link(summaryContainer, 0);
            GridDataFactory.fillDefaults().grab(false, false).align(1, 0x1000000).applyTo((Control)link);
            link.setText(Messages.ConnectorDescriptorToolTip_detailsLink);
            link.setBackground(null);
            link.setToolTipText(NLS.bind((String)Messages.ConnectorDescriptorToolTip_detailsLink_tooltip, (Object)this.overview.getUrl()));
            link.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    WorkbenchUtil.openUrl(OverviewToolTip.this.overview.getUrl(), 128);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
        if (image == null) {
            Point optimalSize = summaryContainer.computeSize(-1, -1, true);
            if (optimalSize.y > 252) {
                ((GridData)summaryContainer.getLayoutData()).heightHint = 242;
                container.layout(true);
            }
        }
        Display.getCurrent().asyncExec(() -> {
            if (!parentComposite.isDisposed()) {
                parentComposite.setFocus();
            }
        });
        return container;
    }

    private Image computeImage(AbstractCatalogSource discoverySource, String imagePath) {
        URL resource = discoverySource.getResource(imagePath);
        if (resource != null) {
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)resource);
            Image image = descriptor.createImage();
            return image;
        }
        return null;
    }

    public void show(Control titleControl) {
        Point titleAbsLocation = titleControl.getParent().toDisplay(titleControl.getLocation());
        Point containerAbsLocation = this.parent.getParent().toDisplay(this.parent.getLocation());
        Rectangle bounds = titleControl.getBounds();
        int relativeX = titleAbsLocation.x - containerAbsLocation.x;
        int relativeY = titleAbsLocation.y - containerAbsLocation.y;
        this.show(new Point(relativeX, relativeY += bounds.height + 3));
    }
}

