/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.hooks;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.service.weaving.ISupplementerRegistry;
import org.eclipse.equinox.weaving.adaptors.Debug;
import org.eclipse.equinox.weaving.adaptors.IWeavingAdaptor;
import org.eclipse.equinox.weaving.adaptors.WeavingAdaptor;
import org.eclipse.equinox.weaving.adaptors.WeavingAdaptorFactory;
import org.eclipse.equinox.weaving.hooks.AbstractWeavingHook;
import org.eclipse.equinox.weaving.hooks.BaseWeavingBundleFile;
import org.eclipse.equinox.weaving.hooks.BundleAdaptorProvider;
import org.eclipse.equinox.weaving.hooks.SupplementBundleListener;
import org.eclipse.equinox.weaving.hooks.WeavingBundleEntry;
import org.eclipse.equinox.weaving.hooks.WeavingBundleFile;
import org.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.eclipse.osgi.internal.loader.classpath.ClasspathEntry;
import org.eclipse.osgi.internal.loader.classpath.ClasspathManager;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.eclipse.osgi.storage.bundlefile.BundleFileWrapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class WeavingHook
extends AbstractWeavingHook {
    private final WeavingAdaptorFactory adaptorFactory;
    private final Map<Long, IWeavingAdaptor> adaptors;
    private BundleContext bundleContext;

    public WeavingHook() {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("- WeavingHook.<init>()");
        }
        this.adaptorFactory = new WeavingAdaptorFactory();
        this.adaptors = new HashMap<Long, IWeavingAdaptor>();
    }

    public void classLoaderCreated(ModuleClassLoader classLoader) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> WeavingHook.initializedClassLoader() bundle=" + classLoader.getBundle().getSymbolicName() + ", loader=" + String.valueOf(classLoader) + ", bundleFile=" + String.valueOf(classLoader.getClasspathManager().getGeneration().getBundleFile()));
        }
        IWeavingAdaptor adaptor = this.createWeavingAdaptor(classLoader.getClasspathManager().getGeneration(), classLoader);
        this.adaptors.put(classLoader.getBundle().getBundleId(), adaptor);
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< WeavingHook.initializedClassLoader() adaptor=" + String.valueOf(adaptor));
        }
    }

    private IWeavingAdaptor createWeavingAdaptor(BundleInfo.Generation generation, ModuleClassLoader classLoader) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> WeavingHook.createAspectJAdaptor() location=" + generation.getRevision().getRevisions().getModule().getLocation());
        }
        WeavingAdaptor adaptor = null;
        if (this.adaptorFactory != null) {
            adaptor = new WeavingAdaptor(generation, this.adaptorFactory, null, null, classLoader);
        } else if (Debug.DEBUG_GENERAL) {
            Debug.println("- WeavingHook.createAspectJAdaptor() factory=" + String.valueOf(this.adaptorFactory));
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< WeavingHook.createAspectJAdaptor() adaptor=" + String.valueOf(adaptor));
        }
        return adaptor;
    }

    @Override
    public IWeavingAdaptor getAdaptor(long bundleID) {
        return this.adaptors.get(bundleID);
    }

    @Override
    public IWeavingAdaptor getHostBundleAdaptor(long bundleID) {
        Bundle host;
        Bundle bundle = this.bundleContext.getBundle(bundleID);
        if (bundle != null && (host = this.adaptorFactory.getHost(bundle)) != null) {
            long hostBundleID = host.getBundleId();
            return this.adaptors.get(hostBundleID);
        }
        return null;
    }

    private void initialize(BundleContext context) {
        Bundle installedBundle;
        Bundle[] installedBundles;
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> WeavingHook.initialize() context=" + String.valueOf(context));
        }
        this.bundleContext = context;
        ISupplementerRegistry supplementerRegistry = this.getSupplementerRegistry();
        this.adaptorFactory.initialize(context, supplementerRegistry);
        ServiceReference serviceReference = context.getServiceReference(PackageAdmin.class);
        PackageAdmin packageAdmin = (PackageAdmin)context.getService(serviceReference);
        supplementerRegistry.setBundleContext(context);
        supplementerRegistry.setPackageAdmin(packageAdmin);
        context.addBundleListener((BundleListener)new SupplementBundleListener(supplementerRegistry));
        Bundle[] bundleArray = installedBundles = context.getBundles();
        int n = installedBundles.length;
        int n2 = 0;
        while (n2 < n) {
            installedBundle = bundleArray[n2];
            if (installedBundle.getState() != 1) {
                supplementerRegistry.addSupplementer(installedBundle, false);
            }
            ++n2;
        }
        bundleArray = installedBundles;
        n = installedBundles.length;
        n2 = 0;
        while (n2 < n) {
            installedBundle = bundleArray[n2];
            if (installedBundle.getState() != 1) {
                supplementerRegistry.addSupplementedBundle(installedBundle);
            }
            ++n2;
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< WeavingHook.initialize() adaptorFactory=" + String.valueOf(this.adaptorFactory));
        }
    }

    public byte[] processClass(String name, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
        WeavingBundleEntry ajBundleEntry;
        byte[] newClassytes = null;
        if (entry instanceof WeavingBundleEntry && !(ajBundleEntry = (WeavingBundleEntry)entry).dontWeave()) {
            IWeavingAdaptor adaptor = ajBundleEntry.getAdaptor();
            newClassytes = adaptor.weaveClass(name, classbytes);
        }
        return newClassytes;
    }

    public void recordClassDefine(String name, Class<?> clazz, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
        WeavingBundleEntry ajBundleEntry;
        if (clazz == null) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Error in defining class: " + name);
            }
            return;
        }
        if (entry instanceof WeavingBundleEntry && !(ajBundleEntry = (WeavingBundleEntry)entry).dontWeave()) {
            IWeavingAdaptor adaptor = ajBundleEntry.getAdaptor();
            URL sourceFileURL = ajBundleEntry.getBundleFileURL();
            adaptor.storeClass(name, sourceFileURL, clazz, classbytes);
        }
    }

    @Override
    public void resetAdaptor(long bundleID) {
        this.adaptors.remove(bundleID);
    }

    public void start(BundleContext context) throws BundleException {
        this.initialize(context);
    }

    public void stop(BundleContext context) throws BundleException {
        this.adaptorFactory.dispose(context);
    }

    public BundleFileWrapper wrapBundleFile(BundleFile bundleFile, BundleInfo.Generation generation, boolean base) {
        if (bundleFile.getBaseFile() == null) {
            return null;
        }
        WeavingBundleFile wrapped = null;
        if (Debug.DEBUG_BUNDLE) {
            Debug.println("> WeavingHook.wrapBundleFile() bundle=" + String.valueOf(generation.getRevision() != null ? generation.getRevision().getSymbolicName() : Long.valueOf(generation.getBundleInfo().getBundleId())) + " bundleFile=" + String.valueOf(bundleFile) + ", generation=" + String.valueOf(generation) + ", base=" + base + ", baseFile=" + String.valueOf(bundleFile.getBaseFile()));
        }
        wrapped = base ? new BaseWeavingBundleFile(new BundleAdaptorProvider(generation, this), bundleFile) : new WeavingBundleFile(new BundleAdaptorProvider(generation, this), bundleFile);
        if (Debug.DEBUG_BUNDLE) {
            Debug.println("< WeavingHook.wrapBundleFile() wrapped=" + String.valueOf((Object)wrapped));
        }
        return wrapped;
    }
}

