/*******************************************************************************
 * Copyright (c) 2009, 2019 Xored Software Inc and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *     Xored Software Inc - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.rcptt.ecl.operations.internal.commands;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.operations.AssertNonEmpty;
import org.eclipse.rcptt.ecl.operations.internal.OperationsPlugin;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.ecl.runtime.ISession;

public class AssertNonEmptyService implements ICommandService {

	public IStatus service(Command command, IProcess context)
			throws InterruptedException, CoreException {
		AssertNonEmpty assertEmpty = (AssertNonEmpty) command;

		Object contents = context.getInput()
				.take(ISession.DEFAULT_TAKE_TIMEOUT);
		if (contents == null || contents instanceof IStatus) {
			return new Status(IStatus.ERROR, OperationsPlugin.PLUGIN_ID,
					getMessage(assertEmpty));
		}
		return Status.OK_STATUS;
	}

	private String getMessage(AssertNonEmpty assertEmpty) {
		String message = assertEmpty.getMessage();
		return message == null || message.length() == 0 ? "Assertion failed: expected non-empty pipe"
				: message;
	}

}
