/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.lang.reflect.Modifier;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposalCore;

public class AddArgumentCorrectionProposalCore
extends LinkedCorrectionProposalCore {
    private int[] fInsertIndexes;
    private ITypeBinding[] fParamTypes;
    private ASTNode fCallerNode;

    public AddArgumentCorrectionProposalCore(String label, ICompilationUnit cu, ASTNode callerNode, int[] insertIdx, ITypeBinding[] expectedTypes, int relevance) {
        super(label, cu, (ASTRewrite)null, relevance);
        this.fCallerNode = callerNode;
        this.fInsertIndexes = insertIdx;
        this.fParamTypes = expectedTypes;
    }

    @Override
    protected ASTRewrite getRewrite() {
        AST ast = this.fCallerNode.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ChildListPropertyDescriptor property = this.getProperty();
        int i = 0;
        while (i < this.fInsertIndexes.length) {
            int idx = this.fInsertIndexes[i];
            String key = "newarg_" + i;
            Expression newArg = this.evaluateArgumentExpressions(ast, this.fParamTypes[idx], key);
            ListRewrite listRewriter = rewrite.getListRewrite(this.fCallerNode, property);
            listRewriter.insertAt((ASTNode)newArg, idx, null);
            this.addLinkedPosition(rewrite.track((ASTNode)newArg), i == 0, key);
            ++i;
        }
        return rewrite;
    }

    private ChildListPropertyDescriptor getProperty() {
        List list = this.fCallerNode.structuralPropertiesForType();
        for (StructuralPropertyDescriptor curr : list) {
            if (!curr.isChildListProperty() || !"arguments".equals(curr.getId())) continue;
            return (ChildListPropertyDescriptor)curr;
        }
        return null;
    }

    private Expression evaluateArgumentExpressions(AST ast, ITypeBinding requiredType, String key) {
        CompilationUnit root = (CompilationUnit)this.fCallerNode.getRoot();
        int offset = this.fCallerNode.getStartPosition();
        Expression best = null;
        ITypeBinding bestType = null;
        ScopeAnalyzer analyzer = new ScopeAnalyzer(root);
        IBinding[] iBindingArray = analyzer.getDeclarationsInScope(offset, 2);
        int n = iBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding binding = iBindingArray[n2];
            IVariableBinding curr = (IVariableBinding)binding;
            ITypeBinding type = curr.getType();
            if (type != null && this.canAssign(type, requiredType) && this.testModifier(curr)) {
                if (best == null || this.isMoreSpecific(bestType, type)) {
                    best = ast.newSimpleName(curr.getName());
                    bestType = type;
                }
                this.addLinkedPositionProposal(key, curr.getName());
            }
            ++n2;
        }
        Expression defaultExpression = ASTNodeFactory.newDefaultExpression(ast, requiredType);
        if (best == null) {
            best = defaultExpression;
        }
        this.addLinkedPositionProposal(key, ASTNodes.asString((ASTNode)defaultExpression));
        return best;
    }

    private boolean isMoreSpecific(ITypeBinding best, ITypeBinding curr) {
        return this.canAssign(best, curr) && !this.canAssign(curr, best);
    }

    private boolean canAssign(ITypeBinding curr, ITypeBinding best) {
        return curr.isAssignmentCompatible(best);
    }

    private boolean testModifier(IVariableBinding curr) {
        int staticFinal;
        int modifiers = curr.getModifiers();
        if ((modifiers & (staticFinal = 24)) == staticFinal) {
            return false;
        }
        return !Modifier.isStatic(modifiers) || ASTResolving.isInStaticContext(this.fCallerNode);
    }
}

