/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.internal.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.Declaration;
import org.eclipse.rcptt.ecl.core.ProcInstance;
import org.eclipse.rcptt.ecl.core.Val;
import org.eclipse.rcptt.ecl.internal.core.DeclarationContainer;
import org.eclipse.rcptt.ecl.internal.core.LetService;
import org.eclipse.rcptt.ecl.internal.core.ProcErrorStatus;
import org.eclipse.rcptt.ecl.runtime.BoxedValues;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public class ProcInstanceService
implements ICommandService {
    @Override
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        if (!(command instanceof ProcInstance)) {
            return Status.CANCEL_STATUS;
        }
        ProcInstance instance = (ProcInstance)command;
        DeclarationContainer locals = LetService.getLocals(context);
        boolean inputUsed = false;
        for (Declaration decl : instance.getDefinition().getVals()) {
            if (!(decl instanceof Val)) continue;
            Val val = (Val)EcoreUtil.copy((EObject)((Val)decl));
            val.setValue(BoxedValues.box(instance.eGet(instance.eClass().getEStructuralFeature(val.getName()))));
            if (val.isInput()) {
                inputUsed = true;
            }
            locals.declare(val.getName(), val);
        }
        IStatus s = context.getSession().execute(instance.getDefinition().getBody(), inputUsed ? null : context.getInput(), context.getOutput()).waitFor();
        return s.isOK() ? Status.OK_STATUS : new ProcErrorStatus(s);
    }
}

