/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.preferences.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.BooleanSupplier;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.rcptt.core.IContextProcessor;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.ctx.preferences.impl.Activator;
import org.eclipse.rcptt.ctx.preferences.impl.DialogSettingsUtils;
import org.eclipse.rcptt.ctx.preferences.impl.ResourcesSupport;
import org.eclipse.rcptt.ctx.preferences.impl.SecuritySupport;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.preferences.PrefUtils;
import org.eclipse.rcptt.preferences.PrefData;
import org.eclipse.rcptt.preferences.PrefNode;
import org.eclipse.rcptt.preferences.PreferencesContext;
import org.eclipse.rcptt.preferences.PreferencesFactory;
import org.eclipse.rcptt.preferences.SecurePrefNode;
import org.eclipse.rcptt.preferences.SettingsNode;
import org.eclipse.rcptt.preferences.StringPrefData;
import org.eclipse.rcptt.tesla.core.TeslaLimits;
import org.eclipse.rcptt.tesla.ecl.impl.UIRunnable;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.UIJobCollector;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PreferencesContextProcessor
implements IContextProcessor {
    private static final String SECURE_PREFERENCES_NODE_NAME = "secureStorage";
    private static final String[] EXCLUDE_SCOPE_LIST = new String[]{"default", "configuration"};

    public void apply(final Context contextToApply, BooleanSupplier isCancelled) throws CoreException {
        long stop = System.currentTimeMillis() + (long)TeslaLimits.getContextRunnableTimeout();
        final UIJobCollector collector = new UIJobCollector();
        Job.getJobManager().addJobChangeListener((IJobChangeListener)collector);
        SWTUIPlayer.disableMessageDialogs();
        try {
            try {
                UIRunnable.exec((UIRunnable)new UIRunnable<Object>(){

                    public Object run() throws CoreException {
                        collector.enable();
                        PreferencesContextProcessor.this.doApply((PreferencesContext)contextToApply);
                        return null;
                    }
                }, (int)Math.toIntExact(stop - System.currentTimeMillis()), (BooleanSupplier)isCancelled);
                UIRunnable.exec((UIRunnable)new UIRunnable<Object>(){

                    public Object run() throws CoreException {
                        collector.setNeedDisable();
                        return null;
                    }
                }, (int)Math.toIntExact(stop - System.currentTimeMillis()), (BooleanSupplier)isCancelled);
                collector.join((long)TeslaLimits.getJobTimeout(), isCancelled);
            }
            catch (Exception e) {
                CoreException ee = new CoreException(RcpttPlugin.createStatus((String)("Failed to execute context: " + contextToApply.getName() + " Cause: " + e.getMessage()), (Throwable)e));
                RcpttPlugin.log((Throwable)e);
                throw ee;
            }
        }
        finally {
            SWTUIPlayer.enableMessageDialogs();
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)collector);
        }
    }

    public Context create(EObject param) throws CoreException {
        UIRunnable.exec((UIRunnable)new UIRunnable<PreferencesContext>(){

            public PreferencesContext run() throws CoreException {
                return null;
            }
        });
        return this.doCreate();
    }

    /*
     * Unable to fully structure code
     */
    private void doApply(PreferencesContext context) throws CoreException {
        service = Platform.getPreferencesService();
        rootPreferences = service.getRootNode();
        if (context.isCleanPreferences()) {
            var8_5 = bundles = Activator.getDefault().getBundle().getBundleContext().getBundles();
            var7_7 = bundles.length;
            var6_13 = 0;
            while (var6_13 < var7_7) {
                bundle = var8_5[var6_13];
                DialogSettingsUtils.clearDialogSettings(bundle);
                ++var6_13;
            }
        }
        touchedNodes = new HashSet<String>();
        try {
            for (PrefNode prefNode : context.getContent()) {
                block20: {
                    try {
                        if (prefNode instanceof SecurePrefNode) {
                            try {
                                SecuritySupport.applySecureSettings((SecurePrefNode)prefNode, context.isCleanPreferences());
                            }
                            catch (Throwable e) {
                                RcpttPlugin.log((Throwable)e);
                            }
                        }
                        name = PrefUtils.substituteVariables((String)prefNode.getName());
                        this.applyPreferences(name, prefNode, (Preferences)rootPreferences, context.isCleanPreferences());
                        touchedNodes.add(name);
                        rootPreferences.flush();
                        continue;
                    }
                    catch (Throwable e) {
                        nodeName = prefNode.getName();
                        if (!nodeName.equals("project")) break block20;
                        childs = prefNode.getChilds();
                        ** for (child : childs)
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            ResourcesSupport.checkProjectExistance(child, e);
                        }
                        catch (CoreException e4) {
                            throw e4;
                        }
                        catch (Throwable e3) {
                            RcpttPlugin.log((Throwable)e3);
                        }
                        continue;
                    }
                }
                throw new CoreException(Activator.createStatus("Error during preferences apply for node: \"" + nodeName + "\" caused by: (" + e.getMessage() + ")", e));
            }
            settingsNode = context.getSettings();
            if (settingsNode != null) {
                for (PrefNode prefNode : settingsNode.getChilds()) {
                    this.applyDialogSettings(prefNode);
                }
            }
            if (context.isCleanPreferences()) {
                var9_19 = rootPreferences.keys();
                var8_6 = var9_19.length;
                var7_12 = 0;
                while (var7_12 < var8_6) {
                    key = var9_19[var7_12];
                    if (!touchedNodes.contains(key)) {
                        this.applyPreferences(key, PreferencesFactory.eINSTANCE.createPrefNode(), (Preferences)rootPreferences, context.isCleanPreferences());
                    }
                    ++var7_12;
                }
            }
            rootPreferences.flush();
        }
        catch (IOException e) {
            throw new CoreException(Activator.createStatus("Error during dialog settings applying.", e));
        }
        catch (BackingStoreException e) {
            throw new CoreException(Activator.createStatus("Error during dialog settings applying.", e));
        }
    }

    private String[] getPDECoreRequiredPreferencesList() {
        String[] keys = new String[]{"org.eclipse.pde.ui.arch", "vm_args", "program_args", "org.eclipse.pde.ui.ws", "workspace_target_handle", "platform_path", "org.eclipse.pde.ui.os", "target_mode", "target.profile", "org.eclipse.pde.ui.nl", "pooled_urls", "pooled_bundles"};
        return keys;
    }

    private String[] getJDTCoreRequiredPreferencesList() {
        String[] keys = new String[]{"org.eclipse.jdt.core.classpathVariable.JRE_LIB", "org.eclipse.jdt.core.classpathVariable.JRE_SRC", "org.eclipse.jdt.core.classpathVariable.JRE_SRCROOT"};
        return keys;
    }

    private PreferencesContext doCreate() throws CoreException {
        try {
            PreferencesContext context = PreferencesFactory.eINSTANCE.createPreferencesContext();
            List<PrefNode> prefNodes = this.collectPreferences();
            context.getContent().addAll(prefNodes);
            SettingsNode settings = this.collectDialogSettings();
            if (settings.getChilds().size() > 0) {
                settings.setName("settings");
                context.setSettings(settings);
            }
            try {
                SecurePrefNode secureNode = SecuritySupport.collectSecureSettings();
                if (secureNode.getChilds().size() > 0) {
                    secureNode.setName(SECURE_PREFERENCES_NODE_NAME);
                    context.getContent().add((Object)secureNode);
                }
            }
            catch (Throwable e) {
                Activator.log(e);
            }
            return context;
        }
        catch (BackingStoreException e) {
            throw new CoreException(Activator.createStatus("Error during preferences processing.", e));
        }
        catch (IOException e) {
            throw new CoreException(Activator.createStatus("Error during dialog settings processing.", e));
        }
    }

    public boolean isApplied(Context context) {
        throw new UnsupportedOperationException();
    }

    public boolean isCreateAllowed() {
        return true;
    }

    private void applyPreferences(String nodeName, PrefNode currentPrefNode, Preferences parentPreferences, boolean clean) throws BackingStoreException {
        Preferences preferences = parentPreferences.node(nodeName);
        HashSet<String> datasSet = new HashSet<String>();
        if (nodeName.equals("org.eclipse.pde.core")) {
            datasSet.addAll(Arrays.asList(this.getPDECoreRequiredPreferencesList()));
        }
        if (nodeName.equals("org.eclipse.jdt.core")) {
            datasSet.addAll(Arrays.asList(this.getJDTCoreRequiredPreferencesList()));
        }
        preferences = parentPreferences.node(nodeName);
        EList datas = currentPrefNode.getData();
        for (PrefData data : datas) {
            Bundle ideBundle;
            StringPrefData prefData = (StringPrefData)data;
            if (prefData.getKey().startsWith("org.eclipse.ui.internal.views.markers.CachedMarkerBuilder") && (ideBundle = Platform.getBundle((String)"org.eclipse.ui.ide")) != null && (((String)ideBundle.getHeaders().get("Bundle-Version")).toString().startsWith("3.5") || ((String)ideBundle.getHeaders().get("Bundle-Version")).toString().startsWith("3.4"))) continue;
            PrefUtils.decodePrefData((StringPrefData)prefData);
            PrefUtils.decodeWorkspaceLocation((StringPrefData)prefData);
            PrefUtils.substituteVariables((StringPrefData)prefData);
            datasSet.add(prefData.getKey());
            try {
                preferences.put(prefData.getKey(), prefData.getValue());
            }
            catch (Throwable e) {
                Activator.log(e);
            }
        }
        if (clean) {
            String[] e = preferences.keys();
            int n = e.length;
            int n2 = 0;
            while (n2 < n) {
                String key = e[n2];
                if (!datasSet.contains(key)) {
                    preferences.remove(key);
                }
                ++n2;
            }
        }
        if (nodeName.equals("org.eclipse.ui.workbench") || datasSet.contains("OPEN_ON_SINGLE_CLICK")) {
            this.processOpenStrategy(preferences);
        }
        datasSet.clear();
        EList childs = currentPrefNode.getChilds();
        for (PrefNode child : childs) {
            try {
                String name = PrefUtils.substituteVariables((String)child.getName());
                datasSet.add(name);
                this.applyPreferences(name, child, preferences, false);
            }
            catch (Throwable e) {
                Activator.log(e);
            }
        }
        if (clean) {
            String[] stringArray = preferences.childrenNames();
            int n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String key = stringArray[n3];
                if (!datasSet.contains(key)) {
                    this.applyPreferences(key, PreferencesFactory.eINSTANCE.createPrefNode(), preferences, clean);
                }
                ++n3;
            }
        }
    }

    private void processOpenStrategy(Preferences preferences) {
        int singleClickMethod;
        boolean openOnSingleClick = preferences.getBoolean("OPEN_ON_SINGLE_CLICK", false);
        boolean selectOnHover = preferences.getBoolean("SELECT_ON_HOVER", false);
        boolean openAfterDelay = preferences.getBoolean("OPEN_AFTER_DELAY", false);
        int n = singleClickMethod = openOnSingleClick ? 1 : 0;
        if (openOnSingleClick) {
            if (selectOnHover) {
                singleClickMethod |= 2;
            }
            if (openAfterDelay) {
                singleClickMethod |= 4;
            }
        }
        OpenStrategy.setOpenMethod((int)singleClickMethod);
    }

    private List<PrefNode> collectPreferences() throws BackingStoreException {
        String[] childNames;
        ArrayList<PrefNode> result = new ArrayList<PrefNode>();
        IPreferencesService service = Platform.getPreferencesService();
        IEclipsePreferences root = service.getRootNode();
        String[] stringArray = childNames = root.childrenNames();
        int n = childNames.length;
        int n2 = 0;
        while (n2 < n) {
            PrefNode prefNode;
            String childName = stringArray[n2];
            Preferences child = root.node(childName);
            if (this.shouldProcess(child) && (prefNode = PrefUtils.convertPreferences((Preferences)child)) != null) {
                result.add(prefNode);
            }
            ++n2;
        }
        return result;
    }

    private boolean shouldProcess(Preferences preferences) {
        String[] stringArray = EXCLUDE_SCOPE_LIST;
        int n = EXCLUDE_SCOPE_LIST.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.equals(preferences.name())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private SettingsNode collectDialogSettings() throws IOException {
        Bundle[] bundles;
        SettingsNode settings = PreferencesFactory.eINSTANCE.createSettingsNode();
        settings.setName("settings");
        Bundle[] bundleArray = bundles = Activator.getDefault().getBundle().getBundleContext().getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            PrefNode prefNode = DialogSettingsUtils.collectDialogSettings(bundle);
            if (prefNode != null) {
                prefNode.setName(bundle.getSymbolicName());
                settings.getChilds().add((Object)prefNode);
            }
            ++n2;
        }
        return settings;
    }

    private void applyDialogSettings(PrefNode prefNode) throws IOException {
        Bundle bundle = Platform.getBundle((String)prefNode.getName());
        if (bundle != null) {
            DialogSettingsUtils.applyDialogSettings(bundle, prefNode);
        }
    }
}

