/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf.model;

import com.google.common.net.UrlEscapers;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Hex;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.sail.nativerdf.ValueStoreRevision;
import org.eclipse.rdf4j.sail.nativerdf.model.CorruptValue;

public class CorruptIRIOrBNode
extends CorruptValue
implements IRI,
BNode {
    private static final long serialVersionUID = 3709784393454516043L;

    public CorruptIRIOrBNode(ValueStoreRevision revision, int internalID, byte[] data) {
        super(revision, internalID, data);
    }

    public String toString() {
        return this.stringValue();
    }

    @Override
    public String stringValue() {
        try {
            return this.getNamespace() + ":" + this.getLocalName();
        }
        catch (Throwable throwable) {
            return "CorruptIRIOrBNode_with_ID_" + this.getInternalID();
        }
    }

    @Override
    public String getNamespace() {
        return "urn:CorruptIRIOrBNode:";
    }

    @Override
    public String getLocalName() {
        byte[] data = this.getData();
        if (data != null && data.length < 1024) {
            try {
                String localName = new String(data, 5, data.length - 5, StandardCharsets.UTF_8);
                return "CORRUPT_" + UrlEscapers.urlPathSegmentEscaper().escape(localName);
            }
            catch (Throwable throwable) {
                return "CORRUPT_" + Hex.encodeHexString((byte[])data);
            }
        }
        return "CORRUPT";
    }

    @Override
    public String getID() {
        return "";
    }

    @Override
    public boolean equals(Object o) {
        CorruptIRIOrBNode otherCorruptValue;
        if (this == o) {
            return true;
        }
        if (o instanceof CorruptIRIOrBNode && this.getInternalID() != -1 && (otherCorruptValue = (CorruptIRIOrBNode)o).getInternalID() != -1 && this.getValueStoreRevision().equals(otherCorruptValue.getValueStoreRevision())) {
            return this.getInternalID() == otherCorruptValue.getInternalID();
        }
        return super.equals(o);
    }
}

