/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir;

import java.util.Collections;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPrinter;

public class IrMinus
extends IrNode {
    private final IrBGP bgp;

    public IrMinus(IrBGP bgp, boolean newScope) {
        super(newScope);
        this.bgp = bgp;
    }

    public IrBGP getWhere() {
        return this.bgp;
    }

    @Override
    public void print(IrPrinter p) {
        IrBGP ow = this.getWhere();
        p.startLine();
        p.append("MINUS ");
        if (ow != null) {
            IrBGP body = ow;
            if (body.getLines().size() == 1 && body.getLines().get(0) instanceof IrBGP) {
                IrBGP inner;
                body = inner = (IrBGP)body.getLines().get(0);
            }
            body.print(p);
        } else {
            p.openBlock();
            p.closeBlock();
        }
    }

    @Override
    public IrNode transformChildren(UnaryOperator<IrNode> op) {
        IrBGP newWhere = this.bgp;
        if (newWhere != null) {
            IrNode t = (IrNode)op.apply(newWhere);
            if ((t = t.transformChildren(op)) instanceof IrBGP) {
                newWhere = (IrBGP)t;
            }
        }
        return new IrMinus(newWhere, this.isNewScope());
    }

    @Override
    public Set<Var> getVars() {
        return this.bgp == null ? Collections.emptySet() : this.bgp.getVars();
    }
}

