/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;

public class LeftJoinIterator
extends LookAheadIteration<BindingSet> {
    private final CloseableIteration<BindingSet> leftIter;
    private final QueryEvaluationStep rightEvaluationStep;
    private CloseableIteration<BindingSet> rightIter;

    public LeftJoinIterator(EvaluationStrategy strategy, LeftJoin join, BindingSet bindings, QueryEvaluationStep rightEvaluationStep) throws QueryEvaluationException {
        this.leftIter = strategy.evaluate(join.getLeftArg(), bindings);
        this.rightIter = null;
        join.setAlgorithm(this);
        this.rightEvaluationStep = rightEvaluationStep;
    }

    public LeftJoinIterator(QueryEvaluationStep left, BindingSet bindings, QueryEvaluationStep rightEvaluationStep) throws QueryEvaluationException {
        this(left.evaluate(bindings), rightEvaluationStep);
    }

    public LeftJoinIterator(CloseableIteration<BindingSet> leftIter, QueryEvaluationStep rightEvaluationStep) {
        this.leftIter = leftIter;
        this.rightIter = null;
        this.rightEvaluationStep = rightEvaluationStep;
    }

    public static CloseableIteration<BindingSet> getInstance(QueryEvaluationStep left, BindingSet bindings, QueryEvaluationStep rightEvaluationStep) {
        CloseableIteration<BindingSet> leftIter = left.evaluate(bindings);
        if (leftIter == QueryEvaluationStep.EMPTY_ITERATION) {
            return leftIter;
        }
        return new LeftJoinIterator(leftIter, rightEvaluationStep);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected BindingSet getNextElement() throws QueryEvaluationException {
        try {
            CloseableIteration<BindingSet> nextRightIter = this.rightIter;
            while (nextRightIter == null || nextRightIter.hasNext() || this.leftIter.hasNext()) {
                BindingSet leftBindings = null;
                if (nextRightIter == null) {
                    if (!this.leftIter.hasNext()) return null;
                    leftBindings = (BindingSet)this.leftIter.next();
                    nextRightIter = this.rightIter = this.rightEvaluationStep.evaluate(leftBindings);
                } else if (!nextRightIter.hasNext()) {
                    leftBindings = (BindingSet)this.leftIter.next();
                    nextRightIter.close();
                    nextRightIter = this.rightIter = this.rightEvaluationStep.evaluate(leftBindings);
                }
                if (nextRightIter == QueryEvaluationStep.EMPTY_ITERATION) {
                    this.rightIter = null;
                    return leftBindings;
                }
                if (nextRightIter.hasNext()) {
                    return (BindingSet)nextRightIter.next();
                }
                if (leftBindings == null) continue;
                this.rightIter = null;
                return leftBindings;
            }
            return null;
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return null;
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        try {
            this.leftIter.close();
        }
        finally {
            if (this.rightIter != null) {
                this.rightIter.close();
            }
        }
    }
}

