/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.opposites.DefaultOppositeEndFinder;
import org.eclipse.ocl.ecore.opposites.OppositeEndFinder;
import org.eclipse.ocl.examples.eventmanager.EventFilter;
import org.eclipse.ocl.examples.impactanalyzer.ImpactAnalyzer;
import org.eclipse.ocl.examples.impactanalyzer.configuration.ActivationOption;
import org.eclipse.ocl.examples.impactanalyzer.filterSynthesis.FilterSynthesisImpl;
import org.eclipse.ocl.examples.impactanalyzer.impl.ContextTypeRetriever;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.InstanceScopeAnalysis;
import org.eclipse.ocl.examples.impactanalyzer.util.OCLFactory;
import org.eclipse.ocl.utilities.Visitor;

public class ImpactAnalyzerImpl
implements ImpactAnalyzer {
    private final OCLExpression expression;
    private FilterSynthesisImpl filtersyn;
    private InstanceScopeAnalysis instanceScopeAnalysis;
    private final EClass context;
    private final OppositeEndFinder oppositeEndFinder;
    private final ActivationOption configuration;
    private final boolean notifyOnNewContextElements;
    private final OCLFactory oclFactory;

    public ImpactAnalyzerImpl(OCLExpression expression, boolean notifyOnNewContextElements, ActivationOption configuration, OCLFactory oclFactory) {
        this(expression, notifyOnNewContextElements, (OppositeEndFinder)DefaultOppositeEndFinder.getInstance(), configuration, oclFactory);
    }

    public ImpactAnalyzerImpl(OCLExpression expression, EClass context, boolean notifyOnNewContextElements, ActivationOption configuration, OCLFactory oclFactory) {
        this(expression, context, notifyOnNewContextElements, (OppositeEndFinder)DefaultOppositeEndFinder.getInstance(), configuration, oclFactory);
    }

    public ImpactAnalyzerImpl(OCLExpression expression, boolean notifyOnNewContextElements, OppositeEndFinder oppositeEndFinder, ActivationOption configuration, OCLFactory oclFactory) {
        this.expression = expression;
        this.context = (EClass)expression.accept((Visitor)this.createContextTypeRetriever());
        if (this.context == null) {
            throw new IllegalArgumentException("Expression " + expression + " does not contain a \"self\" variable reference. " + "Therefore, its context type cannot be inferred and needs to be provided explicitly. Consider using " + this.getClass().getName() + "(OCLExpression, EClass, OppositeEndFinder) instead.");
        }
        this.oppositeEndFinder = oppositeEndFinder;
        this.configuration = configuration;
        this.notifyOnNewContextElements = notifyOnNewContextElements;
        this.oclFactory = oclFactory;
    }

    public ImpactAnalyzerImpl(OCLExpression expression, EClass context, boolean notifyOnNewContextElements, OppositeEndFinder oppositeEndFinder, ActivationOption configuration, OCLFactory oclFactory) {
        this.expression = expression;
        this.context = context;
        EClass inferredContext = (EClass)expression.accept((Visitor)this.createContextTypeRetriever());
        if (inferredContext != null && inferredContext != context) {
            throw new IllegalArgumentException("Redundant, incorrect context type specification. Expression has " + inferredContext + " as context type, but explicitly-provided context type was " + context);
        }
        this.oppositeEndFinder = oppositeEndFinder;
        this.configuration = configuration;
        this.notifyOnNewContextElements = notifyOnNewContextElements;
        this.oclFactory = oclFactory;
    }

    protected ContextTypeRetriever createContextTypeRetriever() {
        return new ContextTypeRetriever();
    }

    @Override
    public EventFilter createFilterForExpression() {
        if (this.filtersyn == null) {
            this.filtersyn = this.createFilterSynthesis(this.expression, this.notifyOnNewContextElements, this.oclFactory.createOCL(this.oppositeEndFinder));
        }
        return this.filtersyn.getSynthesisedFilter();
    }

    protected FilterSynthesisImpl createFilterSynthesis(OCLExpression expression, boolean notifyOnNewContextElements, OCL ocl) {
        return new FilterSynthesisImpl(expression, notifyOnNewContextElements, ocl);
    }

    @Override
    public Collection<EObject> getContextObjects(Notification event) {
        if (this.instanceScopeAnalysis == null) {
            this.instanceScopeAnalysis = this.createInstanceScopeAnalysis();
        }
        return this.instanceScopeAnalysis.getContextObjects(event, this.notifyOnNewContextElements);
    }

    @Override
    public Collection<EObject> getContextObjects(EObject evaluationResult) {
        if (this.instanceScopeAnalysis == null) {
            this.instanceScopeAnalysis = this.createInstanceScopeAnalysis();
        }
        return this.instanceScopeAnalysis.getContextObjects(evaluationResult);
    }

    protected InstanceScopeAnalysis createInstanceScopeAnalysis() {
        if (this.filtersyn == null) {
            this.createFilterForExpression();
        }
        return new InstanceScopeAnalysis(this.expression, this.context, this.filtersyn, this.oppositeEndFinder, this.configuration, this.oclFactory);
    }

    protected OCLExpression getExpression() {
        return this.expression;
    }
}

