/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.compiler.ast.nodes;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.core.compiler.ast.nodes.Attribute;
import org.eclipse.php.core.compiler.ast.nodes.FormalParameter;
import org.eclipse.php.core.compiler.ast.nodes.IAttributed;
import org.eclipse.php.core.compiler.ast.nodes.ReturnType;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class ArrowFunctionDeclaration
extends Expression
implements IAttributed {
    private final boolean isReference;
    private final boolean isStatic;
    protected List<FormalParameter> arguments = new LinkedList<FormalParameter>();
    private Expression body;
    private ReturnType returnType;
    private List<Attribute> attributes;

    public ArrowFunctionDeclaration(int start, int end, List<FormalParameter> formalParameters, Expression body, boolean isReference, boolean isStatic, TypeReference returnType) {
        super(start, end);
        if (formalParameters != null) {
            this.arguments = formalParameters;
        }
        this.body = body;
        this.isReference = isReference;
        this.isStatic = isStatic;
        this.setReturnType(returnType);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((Expression)this);
        if (visit) {
            if (this.attributes != null) {
                for (Attribute attr : this.attributes) {
                    attr.traverse(visitor);
                }
            }
            for (FormalParameter param : this.arguments) {
                param.traverse(visitor);
            }
            if (this.returnType != null) {
                this.returnType.traverse(visitor);
            }
            if (this.body != null) {
                this.body.traverse(visitor);
            }
        }
        visitor.endvisit((Expression)this);
    }

    public Collection<FormalParameter> getArguments() {
        return this.arguments;
    }

    public Expression getBody() {
        return this.body;
    }

    public void setBody(Expression body) {
        this.body = body;
    }

    public boolean isReference() {
        return this.isReference;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public TypeReference getReturnType() {
        if (this.returnType != null) {
            return this.returnType.getReturnType();
        }
        return null;
    }

    public void setReturnType(TypeReference returnType) {
        if (returnType != null) {
            this.returnType = new ReturnType(returnType);
        }
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }

    public int getKind() {
        return 78;
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }
}

