/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.views.coverage;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.core.PHPToolkitUtil;
import org.eclipse.php.internal.debug.core.zend.debugger.CodeCoverageData;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.views.coverage.CodeCoverageActionGroup;
import org.eclipse.php.internal.debug.ui.views.coverage.CodeCoverageContentProvider;
import org.eclipse.php.internal.debug.ui.views.coverage.CodeCoverageLabelProvider;
import org.eclipse.php.internal.debug.ui.views.coverage.CodeCoverageSorter;
import org.eclipse.php.internal.debug.ui.views.coverage.CodeCoverageViewer;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.part.ViewPart;

public class CodeCoverageSection
implements Listener {
    private CodeCoverageActionGroup actionGroup;
    private Cursor arrowCursor;
    private CodeCoverageContentProvider cProvider;
    private Cursor handCursor;
    private CodeCoverageViewer viewer;
    public static final String CODE_COVERAGE_ICON_PATH = "obj16/cov_statistic_co.gif";

    public CodeCoverageSection(Composite parent, ViewPart view, ToolBar codeCoverageToolBar) {
        this.viewer = new CodeCoverageViewer(parent);
        this.cProvider = new CodeCoverageContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.cProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new CodeCoverageLabelProvider(this.cProvider));
        this.viewer.setSorter((ViewerSorter)new CodeCoverageSorter());
        this.actionGroup = new CodeCoverageActionGroup(this.viewer);
        this.viewer.getTree().addListener(8, (Listener)this);
        this.viewer.getTree().addListener(3, (Listener)this);
        this.viewer.getTree().addListener(5, (Listener)this);
    }

    public void handleEvent(Event event) {
        Point p = new Point(event.x, event.y);
        TreeItem item = this.getTreeItem(p);
        int column = this.getColumn(p);
        if (event.type == 8) {
            this.doubleClick(item, column);
        }
        if (event.type == 3) {
            this.click(item, column);
        }
        if (event.type == 5) {
            this.hover(item, column);
        }
    }

    public void addFilter(ViewerFilter filter) {
        this.viewer.addFilter(filter);
    }

    public void dispose() {
        if (this.arrowCursor != null) {
            this.arrowCursor.dispose();
        }
        if (this.handCursor != null) {
            this.handCursor.dispose();
        }
        if (!this.viewer.getTree().isDisposed()) {
            this.viewer.getTree().removeListener(8, (Listener)this);
            this.viewer.getTree().removeListener(3, (Listener)this);
            this.viewer.getTree().removeListener(5, (Listener)this);
            this.viewer.dispose();
        }
    }

    public Control getComposite() {
        return this.viewer.getTree();
    }

    public void showCodeCoverage(CodeCoverageData[] coveredFiles) {
        if (coveredFiles != null) {
            if (!this.viewer.getTree().isDisposed()) {
                CodeCoverageData[] codeCoverageDataArray = coveredFiles;
                int n = coveredFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    CodeCoverageData element = codeCoverageDataArray[n2];
                    String localFileName = element.getLocalFileName();
                    IFile resource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(localFileName));
                    if (resource != null && resource instanceof IFile) {
                        IFile file = resource;
                        this.cProvider.setProject(file.getProject());
                        break;
                    }
                    ++n2;
                }
                this.cProvider.setCoveredFiles(coveredFiles);
                this.viewer.setAutoExpandLevel(2);
                this.viewer.getControl().setRedraw(false);
                this.viewer.setInput(ResourcesPlugin.getWorkspace().getRoot());
                this.viewer.getControl().setRedraw(true);
                this.viewer.refresh(false);
            }
        } else if (this.viewer.getContentProvider() != null) {
            this.viewer.setInput(null);
        }
    }

    private void click(TreeItem item, int column) {
        Object fileData = this.getFileData(item);
        if (column == 1 && (fileData instanceof ISourceModule || fileData instanceof IFile || fileData instanceof String)) {
            this.actionGroup.showCoverage(fileData);
        }
    }

    private void doubleClick(TreeItem item, int column) {
        if (column == 0 && item != null) {
            this.actionGroup.doubleClickFile(item.getData());
        }
    }

    private Cursor getArrowCursor() {
        if (this.arrowCursor == null) {
            this.arrowCursor = new Cursor((Device)this.viewer.getTree().getDisplay(), 0);
        }
        return this.arrowCursor;
    }

    private int getColumn(Point p) {
        TreeColumn[] columns = this.viewer.getTree().getColumns();
        int[] order = this.viewer.getTree().getColumnOrder();
        Rectangle bounds = this.viewer.getTree().getBounds();
        int gridLineWidth = this.viewer.getTree().getGridLineWidth();
        int left = bounds.x;
        int i = 0;
        while (i < columns.length) {
            int right = left + columns[order[i]].getWidth();
            if (left <= p.x && p.x < right) {
                return order[i];
            }
            left += columns[order[i]].getWidth() + gridLineWidth;
            ++i;
        }
        return 0;
    }

    private Object getFileData(TreeItem item) {
        if (item == null) {
            return null;
        }
        ISourceModule fileData = PHPToolkitUtil.getSourceModule((Object)item.getData());
        if (fileData != null) {
            return fileData;
        }
        return item.getData();
    }

    private Cursor getHandCursor() {
        if (this.handCursor == null) {
            this.handCursor = new Cursor((Device)this.viewer.getTree().getDisplay(), 21);
        }
        return this.handCursor;
    }

    private TreeItem getTreeItem(Point p) {
        TreeItem[] items = this.viewer.getTree().getItems();
        TreeItem foundItem = null;
        int i = 0;
        while (i < items.length) {
            foundItem = this.getTreeItemRecursive(p, items[i]);
            if (foundItem != null) {
                return foundItem;
            }
            ++i;
        }
        return null;
    }

    private TreeItem getTreeItemRecursive(Point p, TreeItem item) {
        Rectangle bounds = item.getBounds();
        TreeItem foundItem = null;
        if (bounds.y <= p.y && bounds.y + bounds.height > p.y) {
            return item;
        }
        TreeItem[] items = item.getItems();
        int i = 0;
        while (i < items.length) {
            foundItem = this.getTreeItemRecursive(p, items[i]);
            if (foundItem != null) {
                return foundItem;
            }
            ++i;
        }
        return null;
    }

    private void hover(TreeItem item, int column) {
        boolean isLink = false;
        Object fileData = this.getFileData(item);
        if (column == 1 && (fileData instanceof ISourceModule || fileData instanceof IFile || fileData instanceof String)) {
            isLink = true;
        }
        this.viewer.getTree().setCursor(isLink ? this.getHandCursor() : this.getArrowCursor());
        if (isLink) {
            this.viewer.getTree().setToolTipText(PHPDebugUIMessages.CodeCoverageSection_1);
        } else {
            this.viewer.getTree().setToolTipText(null);
        }
    }
}

