/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.view.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.php.phpunit.PHPUnitMessages;
import org.eclipse.php.phpunit.PHPUnitPlugin;
import org.eclipse.php.phpunit.ui.view.PHPUnitView;
import org.eclipse.php.phpunit.ui.view.actions.OpenEditorAtLineAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class OpenEditorAction
extends Action {
    public static final String GOTO_CALL = PHPUnitMessages.OpenEditorAction_Go_Call;
    public static final String GOTO_CLASS = PHPUnitMessages.OpenEditorAction_Go_Class;
    public static final String GOTO_FILE = PHPUnitMessages.OpenEditorAction_Go_File;
    public static final String GOTO_FUNCTION = PHPUnitMessages.OpenEditorAction_Go_Func;
    public static final String GOTO_METHOD = PHPUnitMessages.OpenEditorAction_Go_Method;
    public static final String GOTO_OCCURANCE = PHPUnitMessages.OpenEditorAction_Go_Occurence;
    protected String fClassName;
    protected String fFileName;
    protected int fLineNumber;
    protected PHPUnitView fTestRunner;

    protected OpenEditorAction(String label, PHPUnitView testRunner, String className, String fileName, int lineNumber) {
        super(label == null ? GOTO_FILE : label);
        this.fClassName = className;
        this.fFileName = fileName;
        this.fLineNumber = lineNumber;
        this.fTestRunner = testRunner;
    }

    protected IType findClass(IProject project, String className, String fileName) {
        IType[] classes;
        ISourceModule element = null;
        if (fileName != null && !fileName.isEmpty()) {
            Path path = new Path(fileName);
            IFile iFile = path.isAbsolute() ? project.getWorkspace().getRoot().getFileForLocation((IPath)path) : project.getWorkspace().getRoot().getFile((IPath)path);
            element = DLTKCore.createSourceModuleFrom((IFile)iFile);
        }
        if (element == null && (classes = PHPModelAccess.getDefault().findTypes(className, ISearchEngine.MatchRule.EXACT, 0, 0, SearchEngine.createSearchScope((IModelElement)DLTKCore.create((IProject)project)), null)) != null && classes.length > 0) {
            element = classes[0].getSourceModule();
        }
        if (element != null) {
            if (className.contains("\\")) {
                className = className.substring(1 + className.lastIndexOf("\\"));
                try {
                    IType[] allTypes;
                    IType[] iTypeArray = allTypes = element.getAllTypes();
                    int n = allTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType t = iTypeArray[n2];
                        if (t.getElementName().equals(className)) {
                            return t;
                        }
                        ++n2;
                    }
                }
                catch (ModelException modelException) {
                    // empty catch block
                }
            }
            return element.getType(className);
        }
        return null;
    }

    protected abstract IModelElement findElement(IProject var1, String var2, String var3) throws CoreException;

    protected IMethod findFunction(IProject project, String functionName, String fileName) {
        ISourceModule element = null;
        if (fileName != null && !fileName.isEmpty()) {
            Path path = new Path(fileName);
            IFile iFile = path.isAbsolute() && path.getDevice() != null ? project.getWorkspace().getRoot().getFileForLocation((IPath)path) : project.getWorkspace().getRoot().getFile((IPath)path);
            element = DLTKCore.createSourceModuleFrom((IFile)iFile);
        } else {
            IMethod[] methods = PHPModelAccess.getDefault().findMethods(functionName, ISearchEngine.MatchRule.EXACT, 0, 0, SearchEngine.createSearchScope((IModelElement)DLTKCore.create((IProject)project)), null);
            if (methods != null && methods.length > 0) {
                element = methods[0].getSourceModule();
            }
        }
        if (element != null && element.getElementType() == 5) {
            ISourceModule module = element;
            return module.getMethod(functionName);
        }
        return null;
    }

    protected String getClassName() {
        return this.fClassName;
    }

    protected String getFileName() {
        return this.fFileName;
    }

    protected IProject getLaunchedProject() {
        return this.fTestRunner.getProject();
    }

    protected Shell getShell() {
        return this.fTestRunner.getSite().getShell();
    }

    protected abstract void reveal(ITextEditor var1);

    public void run() {
        ITextEditor textEditor = null;
        try {
            IModelElement element = this.findElement(this.getLaunchedProject(), this.fClassName, this.fFileName);
            if (element != null) {
                textEditor = (ITextEditor)EditorUtility.openInEditor((Object)element);
            } else if (this.fFileName != null) {
                textEditor = (ITextEditor)org.eclipse.php.internal.ui.util.EditorUtility.openLocalFile((String)this.fFileName, (int)this.fLineNumber);
            }
            if (textEditor != null) {
                this.reveal(textEditor);
            }
        }
        catch (ModelException e) {
            PHPUnitPlugin.log(e);
            new OpenEditorAtLineAction("", this.fTestRunner, this.fFileName, this.fLineNumber, null).run();
        }
        catch (CoreException e) {
            PHPUnitPlugin.log(e);
            ErrorDialog.openError((Shell)this.getShell(), (String)PHPUnitMessages.OpenEditorAction_Error, (String)PHPUnitMessages.OpenEditorAction_Cant_Open, (IStatus)e.getStatus());
            return;
        }
    }
}

