/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.PHPManualConfig;
import org.eclipse.php.internal.ui.preferences.PHPManualConfigSerializer;
import org.eclipse.php.internal.ui.preferences.PHPManualConfigurationBlock;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.php.internal.ui.util.PHPManual;
import org.eclipse.php.internal.ui.util.PHPManualSite;
import org.eclipse.php.internal.ui.util.PHPManualSiteDescriptor;

public class PHPManualFactory {
    private static PHPManual manual = null;
    private static PHPManualConfig fStoredConfig;

    private static PHPManual createManual(PHPManualSiteDescriptor desc) {
        PHPManualSite site = desc.createSite();
        return new PHPManual(site);
    }

    private static PHPManual createManual(PHPManualConfig config) {
        PHPManualSite site = new PHPManualSite(config.getUrl(), config.getExtension());
        return new PHPManual(site);
    }

    public static PHPManual getManual() {
        String storedConfigString = PreferenceConstants.getPreferenceStore().getString("phpManualSite");
        PHPManualConfig storedConfig = PHPManualConfigSerializer.fromString(storedConfigString);
        if (manual == null || storedConfig == null || !storedConfig.equals(fStoredConfig)) {
            manual = null;
            fStoredConfig = storedConfig;
            PHPManualSiteDescriptor[] descs = PHPUiPlugin.getDefault().getPHPManualSiteDescriptors();
            int i = 0;
            while (i < descs.length) {
                if (storedConfig != null && storedConfig.getUrl().equals(descs[i].getURL())) {
                    manual = PHPManualFactory.createManual(descs[i]);
                    break;
                }
                ++i;
            }
            if (manual == null) {
                ArrayList<PHPManualConfig> configs = new ArrayList<PHPManualConfig>();
                PHPManualConfigurationBlock.initFromPreferences(PreferenceConstants.getPreferenceStore(), configs);
                if (configs.size() > 0) {
                    PHPManualConfig defaultConfig = PHPManualConfigurationBlock.getActiveManualSite(PreferenceConstants.getPreferenceStore(), configs);
                    manual = defaultConfig != null ? PHPManualFactory.createManual(defaultConfig) : PHPManualFactory.createManual((PHPManualConfig)configs.get(0));
                } else if (descs.length > 0) {
                    manual = PHPManualFactory.createManual(descs[0]);
                }
            }
        }
        Assert.isNotNull((Object)manual);
        return manual;
    }
}

