/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.handler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.processes.core.model.ModelManager;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModel;
import org.eclipse.tcf.te.tcf.processes.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.processes.ui.internal.preferences.IPreferenceConsts;
import org.eclipse.tcf.te.tcf.processes.ui.internal.preferences.PreferencesInitializer;
import org.eclipse.tcf.te.tcf.processes.ui.nls.Messages;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public class ConfigIntervalDynamicContribution
extends CompoundContributionItem
implements IPreferenceConsts {
    private static final String CUSTOM_COMMAND_ID = "org.eclipse.tcf.te.tcf.processes.ui.command.refreshInterval";

    protected IContributionItem[] getContributionItems() {
        IEditorInput editorInput = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput();
        IPeerNode peerNode = (IPeerNode)editorInput.getAdapter(IPeerNode.class);
        ArrayList<Object> items = new ArrayList<Object>();
        if (peerNode != null) {
            IRuntimeModel model = ModelManager.getRuntimeModel((IPeerNode)peerNode);
            List<IContributionItem> groupItems = this.createGradeActions(model);
            if (!groupItems.isEmpty()) {
                items.addAll(groupItems);
            }
            if (!(groupItems = this.createMRUActions(model)).isEmpty()) {
                items.add(new Separator("MRU"));
                items.addAll(groupItems);
            }
        }
        return items.toArray(new IContributionItem[items.size()]);
    }

    private List<IContributionItem> createGradeActions(IRuntimeModel model) {
        ArrayList<IContributionItem> items = new ArrayList<IContributionItem>();
        IPreferenceStore prefStore = UIPlugin.getDefault().getPreferenceStore();
        String grades = prefStore.getString("PrefIntervalGrades");
        Assert.isNotNull((Object)grades);
        StringTokenizer st = new StringTokenizer(grades, "|");
        int current = model.getAutoRefreshInterval();
        boolean custom = true;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(token, ":");
            String name = st2.nextToken();
            String value = st2.nextToken();
            try {
                int seconds = Integer.parseInt(value);
                GradeAction action = new GradeAction(model, name, seconds);
                boolean checked = current == seconds;
                action.setChecked(checked);
                custom &= !checked;
                items.add((IContributionItem)new ActionContributionItem((IAction)action));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        CustomAction action = new CustomAction();
        action.setChecked(custom);
        items.add((IContributionItem)new ActionContributionItem((IAction)action));
        return items;
    }

    private List<IContributionItem> createMRUActions(IRuntimeModel model) {
        ArrayList<IContributionItem> items = new ArrayList<IContributionItem>();
        IPreferenceStore prefStore = UIPlugin.getDefault().getPreferenceStore();
        String mruList = prefStore.getString("PrefIntervalMRUList");
        if (mruList != null) {
            StringTokenizer st = new StringTokenizer(mruList, ":");
            int maxCount = prefStore.getInt("PrefIntervalMRUCount");
            int count = 0;
            ArrayList<Integer> mru = new ArrayList<Integer>();
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                try {
                    int seconds = Integer.parseInt(token);
                    mru.add(seconds);
                    if (++count < maxCount) continue;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (count > 0) {
                Iterator iterator = mru.iterator();
                while (iterator.hasNext()) {
                    int seconds = (Integer)iterator.next();
                    items.add((IContributionItem)new ActionContributionItem((IAction)new MRUAction(model, seconds)));
                }
            }
        }
        return items;
    }

    static class CustomAction
    extends Action {
        public CustomAction() {
            super(Messages.ConfigIntervalDynamicContribution_Custom, 8);
        }

        public void run() {
            if (this.isChecked()) {
                Command cmd;
                IWorkbench workbench = PlatformUI.getWorkbench();
                ICommandService service = (ICommandService)workbench.getService(ICommandService.class);
                Command command = cmd = service != null ? service.getCommand(ConfigIntervalDynamicContribution.CUSTOM_COMMAND_ID) : null;
                if (cmd != null && cmd.isDefined() && cmd.isEnabled()) {
                    final Command command2 = cmd;
                    SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                        public void handleException(Throwable e) {
                        }

                        public void run() throws Exception {
                            IHandlerService handlerSvc = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                            Assert.isNotNull((Object)handlerSvc);
                            EvaluationContext ctx = new EvaluationContext(handlerSvc.getCurrentState(), (Object)StructuredSelection.EMPTY);
                            ctx.setAllowPluginActivation(true);
                            ParameterizedCommand pCmd = ParameterizedCommand.generateCommand((Command)command2, null);
                            Assert.isNotNull((Object)pCmd);
                            handlerSvc.executeCommandInContext(pCmd, null, (IEvaluationContext)ctx);
                        }
                    });
                }
            }
        }
    }

    static class GradeAction
    extends Action {
        private IRuntimeModel model;
        private int seconds;

        public GradeAction(IRuntimeModel model, String name, int seconds) {
            super(String.valueOf(name) + (seconds > 0 ? " (" + seconds + " s)" : ""), 8);
            this.model = model;
            this.seconds = seconds;
        }

        public void run() {
            if (this.isChecked()) {
                this.model.setAutoRefreshInterval(this.seconds);
                PreferencesInitializer.addMRUInterval(this.seconds);
            }
        }
    }

    static class MRUAction
    extends Action {
        private IRuntimeModel model;
        private int seconds;

        public MRUAction(IRuntimeModel model, int seconds) {
            super(seconds + " s", 8);
            this.seconds = seconds;
            this.model = model;
            if (model.getAutoRefreshInterval() == seconds) {
                this.setChecked(true);
            }
        }

        public void run() {
            if (this.isChecked()) {
                this.model.setAutoRefreshInterval(this.seconds);
            }
        }
    }
}

