/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.notifications.internal.popup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.tcf.te.runtime.events.NotifyEvent;
import org.eclipse.tcf.te.ui.notifications.internal.popup.NotificationPopup;
import org.eclipse.tcf.te.ui.notifications.nls.Messages;
import org.eclipse.ui.PlatformUI;

public class PopupNotificationSink {
    private static final long DELAY_OPEN = 1000L;
    private static final boolean runSystem = true;
    NotificationPopup popup;
    final Set<NotifyEvent> currentlyNotifying = Collections.synchronizedSet(new HashSet());
    private final Job openJob = new Job(Messages.PopupNotificationSink_Popup_Notifier_Job_Label){

        protected IStatus run(IProgressMonitor monitor) {
            if (Platform.isRunning() && PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getDisplay() != null && !PlatformUI.getWorkbench().getDisplay().isDisposed()) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Class<PopupNotificationSink> clazz = PopupNotificationSink.class;
                        synchronized (PopupNotificationSink.class) {
                            if ((this).PopupNotificationSink.this.currentlyNotifying.size() > 0) {
                                PopupNotificationSink.this.showPopup();
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                });
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    };

    public PopupNotificationSink() {
        this.openJob.setSystem(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(NotifyEvent[] events) {
        Assert.isNotNull((Object)events);
        Class<PopupNotificationSink> clazz = PopupNotificationSink.class;
        synchronized (PopupNotificationSink.class) {
            this.currentlyNotifying.addAll(Arrays.asList(events));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (!this.openJob.cancel()) {
                try {
                    this.openJob.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.openJob.schedule(1000L);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void showPopup() {
        if (this.popup != null) {
            this.popup.close();
        }
        if (!PlatformUI.isWorkbenchRunning() || PlatformUI.getWorkbench() == null || PlatformUI.getWorkbench().getDisplay() == null || PlatformUI.getWorkbench().getDisplay().isDisposed()) return;
        this.popup = new NotificationPopup(PlatformUI.getWorkbench().getDisplay().getActiveShell());
        ArrayList<NotifyEvent> toDisplay = new ArrayList<NotifyEvent>(this.currentlyNotifying);
        Class<PopupNotificationSink> clazz = PopupNotificationSink.class;
        synchronized (PopupNotificationSink.class) {
            this.currentlyNotifying.clear();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            Collections.sort(toDisplay);
            this.popup.setContents(toDisplay);
            this.popup.setBlockOnOpen(false);
            this.popup.open();
            return;
        }
    }
}

