/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.registry.internal;

import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.tm4e.registry.GrammarDefinition;
import org.eclipse.tm4e.registry.IGrammarDefinition;
import org.eclipse.tm4e.registry.IGrammarRegistryManager;
import org.eclipse.tm4e.registry.internal.AbstractGrammarRegistryManager;
import org.eclipse.tm4e.registry.internal.PreferenceHelper;
import org.eclipse.tm4e.registry.internal.WorkingCopyGrammarRegistryManager;
import org.osgi.service.prefs.BackingStoreException;

public final class GrammarRegistryManager
extends AbstractGrammarRegistryManager {
    private static final String EXTENSION_GRAMMARS = "grammars";

    public static GrammarRegistryManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private GrammarRegistryManager() {
    }

    private void load() {
        this.loadGrammarsFromExtensionPoints();
        this.loadGrammarsFromPreferences();
    }

    private void loadGrammarsFromExtensionPoints() {
        IConfigurationElement[] cf;
        IConfigurationElement[] iConfigurationElementArray = cf = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.tm4e.registry", EXTENSION_GRAMMARS);
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            String extensionName;
            IConfigurationElement ce = iConfigurationElementArray[n2];
            switch (extensionName = ce.getName()) {
                case "grammar": {
                    this.registerGrammarDefinition(new GrammarDefinition(ce));
                    break;
                }
                case "injection": {
                    String scopeName = ce.getAttribute("scopeName");
                    String injectTo = ce.getAttribute("injectTo");
                    this.registerInjection(scopeName, injectTo);
                    break;
                }
                case "scopeNameContentTypeBinding": {
                    String contentTypeId = ce.getAttribute("contentTypeId");
                    IContentType contentType = Platform.getContentTypeManager().getContentType(contentTypeId);
                    if (contentType == null) {
                        Platform.getLog(this.getClass()).warn("No content-type found with id='" + contentTypeId + "', ignoring TM4E association.");
                        break;
                    }
                    String scopeName = ce.getAttribute("scopeName");
                    this.registerContentTypeToScopeBinding(ce.getNamespaceIdentifier(), contentType, scopeName);
                }
            }
            ++n2;
        }
    }

    private void loadGrammarsFromPreferences() {
        List<IGrammarDefinition> definitions = PreferenceHelper.loadGrammars();
        if (definitions != null) {
            for (IGrammarDefinition definition : definitions) {
                this.userDefinitions.add(definition);
            }
        }
    }

    void save() throws BackingStoreException {
        PreferenceHelper.saveGrammars(this.userDefinitions.stream().toList());
    }

    @Override
    public IGrammarRegistryManager.EditSession newEditSession() {
        return new WorkingCopyGrammarRegistryManager(this);
    }

    private static final class InstanceHolder {
        static final GrammarRegistryManager INSTANCE = new GrammarRegistryManager();

        static {
            INSTANCE.load();
        }

        private InstanceHolder() {
        }
    }
}

