/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.generic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.IIteratingSearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.SingleValueExtendOperationExecutor;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.VolatileMaskedTuple;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

public class GenericTypeExtendSingleValue
implements IIteratingSearchOperation {
    private final IInputKey type;
    private final List<Integer> positionList;
    private final TupleMask indexerMask;
    private final TupleMask callMask;
    private final int unboundVariableIndex;

    public GenericTypeExtendSingleValue(IInputKey type, int[] positions, TupleMask callMask, TupleMask indexerMask, int unboundVariableIndex) {
        Preconditions.checkArgument((positions.length == type.getArity() ? 1 : 0) != 0, (String)"The type %s requires %d parameters, but %d positions are provided", (Object[])new Object[]{type.getPrettyPrintableName(), type.getArity(), positions.length});
        ArrayList<Integer> modifiablePositionList = new ArrayList<Integer>();
        int[] nArray = positions;
        int n = positions.length;
        int n2 = 0;
        while (n2 < n) {
            int position = nArray[n2];
            modifiablePositionList.add(position);
            ++n2;
        }
        this.unboundVariableIndex = unboundVariableIndex;
        this.positionList = Collections.unmodifiableList(modifiablePositionList);
        this.type = type;
        this.callMask = callMask;
        this.indexerMask = indexerMask;
    }

    @Override
    public IInputKey getIteratedInputKey() {
        return this.type;
    }

    @Override
    public ISearchOperation.ISearchOperationExecutor createExecutor() {
        return new Executor(this.unboundVariableIndex);
    }

    @Override
    public List<Integer> getVariablePositions() {
        return this.positionList;
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    @Override
    public String toString(Function<Integer, String> variableMapping) {
        return "extend    " + this.type.getPrettyPrintableName() + "(" + this.positionList.stream().map(input -> String.format("%s%s", Objects.equals(input, this.unboundVariableIndex) ? "-" : "+", variableMapping.apply((Integer)input))).collect(Collectors.joining(", ")) + ")";
    }

    private class Executor
    extends SingleValueExtendOperationExecutor<Object> {
        private final VolatileMaskedTuple maskedTuple;

        public Executor(int position) {
            super(position);
            this.maskedTuple = new VolatileMaskedTuple(GenericTypeExtendSingleValue.this.callMask);
        }

        @Override
        protected Iterator<? extends Object> getIterator(MatchingFrame frame, ISearchContext context) {
            this.maskedTuple.updateTuple((ITuple)frame);
            return context.getRuntimeContext().enumerateValues(GenericTypeExtendSingleValue.this.type, GenericTypeExtendSingleValue.this.indexerMask, (ITuple)this.maskedTuple).iterator();
        }

        @Override
        public ISearchOperation getOperation() {
            return GenericTypeExtendSingleValue.this;
        }
    }
}

