/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.palette.model.entry;

import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.requests.ICreationFactory;
import org.eclipse.wb.gef.core.tools.CreationTool;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.editor.palette.model.entry.AttributesProvider;
import org.eclipse.wb.internal.core.editor.palette.model.entry.FactoryEntryInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.factory.InstanceFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.InstanceFactoryInfo;
import org.eclipse.wb.internal.core.model.util.ObjectsLabelProvider;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;

public final class InstanceFactoryEntryInfo
extends FactoryEntryInfo {
    public InstanceFactoryEntryInfo() {
    }

    public InstanceFactoryEntryInfo(CategoryInfo categoryInfo, String factoryClassName, AttributesProvider attributes) {
        super(categoryInfo, factoryClassName, attributes);
    }

    public String toString() {
        return "InstanceFactoryMethod(class='" + this.m_factoryClassName + "' signature='" + this.m_methodSignature + "')";
    }

    @Override
    protected boolean isStaticFactory() {
        return false;
    }

    @Override
    public Tool createTool() throws Exception {
        if (!this.ensureComponentDescription()) {
            return null;
        }
        final InstanceFactoryInfo factoryInfo = this.getFactory();
        if (factoryInfo == null) {
            return null;
        }
        ICreationFactory creationFactory = new ICreationFactory(){
            private JavaInfo m_javaInfo;

            public void activate() throws Exception {
                InstanceFactoryCreationSupport creationSupport = new InstanceFactoryCreationSupport(factoryInfo, InstanceFactoryEntryInfo.this.m_methodDescription);
                this.m_javaInfo = InstanceFactoryEntryInfo.this.createJavaInfo(creationSupport);
                this.m_javaInfo = JavaInfoUtils.getWrapped(this.m_javaInfo);
                this.m_javaInfo.putArbitraryValue("manuallyCreatedComponent", Boolean.TRUE);
            }

            public Object getNewObject() {
                return this.m_javaInfo;
            }
        };
        return new CreationTool(creationFactory);
    }

    private InstanceFactoryInfo getFactory() throws Exception {
        List<InstanceFactoryInfo> factories = InstanceFactoryInfo.getFactories(this.m_rootJavaInfo, this.m_factoryClass);
        if (factories.size() == 1) {
            return factories.get(0);
        }
        if (factories.size() == 0) {
            final InstanceFactoryInfo[] result = new InstanceFactoryInfo[1];
            ExecutionUtils.run((ObjectInfo)this.m_rootJavaInfo, (RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    result[0] = InstanceFactoryInfo.add(InstanceFactoryEntryInfo.this.m_rootJavaInfo, InstanceFactoryEntryInfo.this.m_factoryClass);
                }
            });
            return result[0];
        }
        Shell shell = DesignerPlugin.getShell();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new ObjectsLabelProvider());
        dialog.setTitle(Messages.InstanceFactoryEntryInfo_selectFactoryTitle);
        dialog.setMessage(Messages.InstanceFactoryEntryInfo_selectFactoryMessage);
        dialog.setElements(factories.toArray());
        dialog.open();
        return (InstanceFactoryInfo)((Object)dialog.getFirstResult());
    }
}

