/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Map;
import org.immutables.value.Value;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.ImmutableIpam;
import org.mandas.docker.client.messages.IpamConfig;

@JsonDeserialize(builder=ImmutableIpam.Builder.class)
@Value.Immutable
public interface Ipam {
    @JsonProperty(value="Driver")
    public String driver();

    @JsonProperty(value="Config")
    @Nullable
    public List<IpamConfig> config();

    @JsonProperty(value="Options")
    @Nullable
    public Map<String, String> options();

    public static Builder builder() {
        return ImmutableIpam.builder();
    }

    public static Ipam create(String driver, List<IpamConfig> config) {
        return Ipam.builder().driver(driver).config(config).options(null).build();
    }

    public static interface Builder {
        public Builder driver(String var1);

        public Builder options(Map<String, ? extends String> var1);

        public Builder config(Iterable<? extends IpamConfig> var1);

        public Ipam build();
    }
}

