/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.configuration;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.axis.AxisEngine;
import org.apache.axis.ConfigurationException;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.configuration.DefaultConfiguration;
import org.apache.axis.configuration.DelegatingWSDDEngineConfiguration;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDDocument;
import org.apache.axis.utils.Admin;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;

public class FileProvider
extends DelegatingWSDDEngineConfiguration {
    protected static Log log = LogFactory.getLog(FileProvider.class.getName());
    private WSDDDeployment deployment = null;
    private String filename;
    private File configFile = null;
    private InputStream myInputStream = null;
    private boolean readOnly = true;
    private boolean searchClasspath = true;

    public FileProvider(String filename) {
        this.filename = filename;
        this.configFile = new File(filename);
        this.check();
    }

    public FileProvider(String basepath, String filename) throws ConfigurationException {
        this.filename = filename;
        File dir = new File(basepath);
        if (!(dir.exists() && dir.isDirectory() && dir.canRead())) {
            throw new ConfigurationException(Messages.getMessage("invalidConfigFilePath", basepath));
        }
        this.configFile = new File(basepath, filename);
        this.check();
    }

    private void check() {
        try {
            this.readOnly = this.configFile.canRead() & !this.configFile.canWrite();
        }
        catch (SecurityException se) {
            this.readOnly = true;
        }
        if (this.readOnly) {
            log.info((Object)Messages.getMessage("readOnlyConfigFile"));
        }
    }

    public FileProvider(InputStream is) {
        this.setInputStream(is);
    }

    public void setInputStream(InputStream is) {
        this.myInputStream = is;
    }

    private InputStream getInputStream() {
        return this.myInputStream;
    }

    public WSDDDeployment getDeployment() {
        return this.deployment;
    }

    public void setDeployment(WSDDDeployment deployment) {
        this.deployment = deployment;
    }

    public void setSearchClasspath(boolean searchClasspath) {
        this.searchClasspath = searchClasspath;
    }

    public void configureEngine(AxisEngine engine) throws ConfigurationException {
        try {
            InputStream configFileInputStream = this.getInputStream();
            if (configFileInputStream == null) {
                try {
                    configFileInputStream = new FileInputStream(this.configFile);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (configFileInputStream == null && this.searchClasspath) {
                configFileInputStream = ClassUtils.getResourceAsStream(this.filename, engine.getClass().getClassLoader());
            }
            if (configFileInputStream == null) {
                String type;
                if (this.filename.equals("client-config.wsdd")) {
                    type = "client";
                } else if (this.filename.equals("server-config.wsdd")) {
                    type = "server";
                } else {
                    throw new ConfigurationException(Messages.getMessage("noConfigFile"));
                }
                DefaultConfiguration defaultConfig = new DefaultConfiguration(type);
                defaultConfig.configureEngine(engine);
                this.deployment = defaultConfig.getDeployment();
            } else {
                WSDDDocument doc = new WSDDDocument(XMLUtils.newDocument(configFileInputStream));
                this.deployment = doc.getDeployment();
                this.deployment.configureEngine(engine);
            }
            engine.refreshGlobalOptions();
            this.setInputStream(null);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public void writeEngineConfig(AxisEngine engine) throws ConfigurationException {
        if (!this.readOnly) {
            try {
                Document doc = Admin.listConfig(engine);
                OutputStreamWriter osWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.configFile), XMLUtils.getEncoding());
                PrintWriter writer = new PrintWriter(new BufferedWriter(osWriter));
                XMLUtils.DocumentToWriter(doc, writer);
                writer.println();
                writer.close();
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
        }
    }
}

