/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.launch;

import java.util.List;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.StackFramesVMNode;
import org.eclipse.cdt.dsf.gdb.internal.service.IGDBFocusSynchronizer;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.VMChildrenUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;

public class GdbStackFramesVMNode
extends StackFramesVMNode {
    public GdbStackFramesVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session);
    }

    public int getDeltaFlags(Object e) {
        if (e instanceof IGDBFocusSynchronizer.IGDBFocusChangedEvent) {
            return 0x200000;
        }
        return super.getDeltaFlags(e);
    }

    public void buildDelta(Object e, VMDelta parentDelta, int nodeOffset, RequestMonitor rm) {
        if (e instanceof IGDBFocusSynchronizer.IGDBFocusChangedEvent) {
            this.buildDeltaForFocusChangedEvent((IGDBFocusSynchronizer.IGDBFocusChangedEvent)e, parentDelta, rm);
        } else {
            super.buildDelta(e, parentDelta, nodeOffset, rm);
        }
    }

    private void buildDeltaForFocusChangedEvent(IGDBFocusSynchronizer.IGDBFocusChangedEvent event, final VMDelta parentDelta, final RequestMonitor rm) {
        this.getSession().getExecutor().execute(() -> {
            IDMContext ctx = event.getDMContext();
            if (ctx instanceof IStack.IFrameDMContext) {
                IStack.IFrameDMContext newFrameFocus = (IStack.IFrameDMContext)ctx;
                IMIExecutionDMContext execDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)newFrameFocus, IMIExecutionDMContext.class);
                if (execDmc == null) {
                    rm.done();
                    return;
                }
                IRunControl runControl = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
                if (runControl == null) {
                    rm.done();
                    return;
                }
                if (runControl.isSuspended((IRunControl.IExecutionDMContext)execDmc) || runControl.isStepping((IRunControl.IExecutionDMContext)execDmc)) {
                    this.getVMCIndexForDmc((IVMNode)this, (IDMContext)newFrameFocus, parentDelta, (DataRequestMonitor)new DataRequestMonitor<Integer>(this.getExecutor(), rm){

                        protected void handleSuccess() {
                            final int frameOffset = (Integer)this.getData();
                            GdbStackFramesVMNode.this.getVMProvider().updateNode((IVMNode)GdbStackFramesVMNode.this, (IChildrenUpdate)new VMChildrenUpdate((IModelDelta)parentDelta, GdbStackFramesVMNode.this.getVMProvider().getPresentationContext(), -1, -1, (DataRequestMonitor)new DataRequestMonitor<List<Object>>(GdbStackFramesVMNode.this.getExecutor(), rm){

                                public void handleSuccess() {
                                    List data = (List)this.getData();
                                    if (data != null && data.size() != 0) {
                                        parentDelta.addNode(data.get(frameOffset), frameOffset, 0x4200000);
                                    }
                                    rm.done();
                                }
                            }));
                        }
                    });
                } else {
                    rm.done();
                }
            } else {
                rm.done();
            }
        });
    }
}

