/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.core.envvar.EnvironmentVariableManager;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.HeadlessBuildMessages;
import org.eclipse.cdt.managedbuilder.internal.core.HeadlessBuilderExternalSettingsProvider;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.service.datalocation.Location;

public class HeadlessBuilder
implements IApplication {
    public static final Integer ERROR = 1;
    public static final Integer OK = IApplication.EXIT_OK;
    public static final Integer SHOW_USAGE = 2;
    private static final Set<String> SPECIAL_DIRS = Set.of(".metadata", ".org.eclipse.egit.core.cmp");
    protected final Set<String> projectsToRemove = new HashSet<String>();
    protected final Set<String> projectTreeToRemove = new HashSet<String>();
    protected final Set<String> projectsToImport = new HashSet<String>();
    protected final Set<String> projectTreeToImport = new HashSet<String>();
    protected final Set<String> projectRegExToBuild = new HashSet<String>();
    protected final Set<String> projectRegExToClean = new HashSet<String>();
    protected boolean buildAll = false;
    protected boolean cleanAll = false;
    protected boolean disableIndexer = false;
    protected boolean verboseProgressMonitor = false;
    protected List<ToolOption> toolOptions = new ArrayList<ToolOption>();
    protected Map<String, Set<SavedToolOption>> savedToolOptions = new HashMap<String, Set<SavedToolOption>>();
    protected boolean markerTypesDefault = true;
    protected boolean markerTypesAll = false;
    protected Set<String> markerTypes = new HashSet<String>();
    protected boolean printErrorMarkers = false;
    protected static final String MATCH_ALL_CONFIGS = ".*";

    protected Map<IProject, Set<ICConfigurationDescription>> matchConfigurations(String regularExpression, IProject[] projectList, Map<IProject, Set<ICConfigurationDescription>> cfgMap) {
        try {
            String configRegEx;
            String projectRegEx;
            int separatorIndex = regularExpression.indexOf(47);
            if (separatorIndex == -1 || separatorIndex == regularExpression.length() - 1) {
                projectRegEx = regularExpression;
                configRegEx = MATCH_ALL_CONFIGS;
            } else {
                projectRegEx = regularExpression.substring(0, separatorIndex);
                configRegEx = regularExpression.substring(separatorIndex + 1, regularExpression.length());
            }
            Pattern projectPattern = Pattern.compile(projectRegEx);
            Pattern configPattern = Pattern.compile(configRegEx);
            boolean projectMatched = false;
            boolean configMatched = false;
            IProject[] iProjectArray = projectList;
            int n = projectList.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                Matcher projectMatcher = projectPattern.matcher(project.getName());
                if (projectMatcher.matches()) {
                    projectMatched = true;
                    ICProjectDescription desc = CoreModel.getDefault().getProjectDescription(project, false);
                    if (desc == null) {
                        System.err.println(HeadlessBuildMessages.HeadlessBuilder_project + project.getName() + HeadlessBuildMessages.HeadlessBuilder_Not_CDT_Proj);
                    } else {
                        ICConfigurationDescription[] cfgs;
                        ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgs = desc.getConfigurations();
                        int n3 = cfgs.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n4];
                            Matcher cfgMatcher = configPattern.matcher(cfg.getName());
                            if (cfgMatcher.matches()) {
                                configMatched = true;
                                Set<ICConfigurationDescription> set = cfgMap.get(project);
                                if (set == null) {
                                    set = new HashSet<ICConfigurationDescription>();
                                }
                                set.add(cfg);
                                cfgMap.put(project, set);
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
            if (!projectMatched) {
                System.err.println(HeadlessBuildMessages.HeadlessBuilder_NoProjectMatched + regularExpression + HeadlessBuildMessages.HeadlessBuilder_Skipping2);
            } else if (!configMatched) {
                System.err.println(HeadlessBuildMessages.HeadlessBuilder_NoConfigMatched + regularExpression + HeadlessBuildMessages.HeadlessBuilder_Skipping2);
            }
        }
        catch (PatternSyntaxException e) {
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_RegExSyntaxError + e.toString());
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_Skipping + regularExpression + HeadlessBuildMessages.HeadlessBuilder_Quote);
        }
        return cfgMap;
    }

    protected boolean buildConfigurations(Map<IProject, Set<ICConfigurationDescription>> projConfigs, IProgressMonitor monitor, int buildType, List<String> allBuildErrors) throws CoreException {
        boolean buildSuccessful = true;
        for (Map.Entry<IProject, Set<ICConfigurationDescription>> entry : projConfigs.entrySet()) {
            Set<ICConfigurationDescription> cfgDescs = entry.getValue();
            for (ICConfigurationDescription cfgDesc : cfgDescs) {
                IConfiguration[] configs = new IConfiguration[]{ManagedBuildManager.getConfigurationForDescription(cfgDesc)};
                ManagedBuildManager.buildConfigurations(configs, null, (IProgressMonitor)new SubProgressMonitor(monitor, 1), true, buildType);
                boolean bl = buildSuccessful = buildSuccessful && this.isProjectSuccesfullyBuild(entry.getKey());
                if (!this.printErrorMarkers) continue;
                this.accumulateErrorMarkers(entry.getKey(), allBuildErrors);
            }
        }
        return buildSuccessful;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int importProject(String projURIStr, boolean recurse) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        PrintingProgressMonitor monitor = new PrintingProgressMonitor(this.verboseProgressMonitor);
        InputStream in = null;
        int recurseStatus = OK;
        try {
            IFileStore fstore;
            URI project_uri = null;
            try {
                project_uri = URI.create(projURIStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (project_uri == null || project_uri.getScheme() == null) {
                IPath p = new Path(projURIStr).addTrailingSeparator();
                project_uri = URIUtil.toURI((IPath)p);
                if (project_uri.getScheme() == null) {
                    String cwd = System.getProperty("user.dir");
                    p = new Path(cwd).addTrailingSeparator();
                    p = p.append(projURIStr);
                    project_uri = URIUtil.toURI((IPath)p);
                }
                if (project_uri.getScheme() == null) {
                    System.err.println(HeadlessBuildMessages.HeadlessBuilder_invalid_uri + String.valueOf(project_uri));
                    int n = ERROR;
                    return n;
                }
            }
            if (SPECIAL_DIRS.contains(EFS.getStore((URI)project_uri).fetchInfo().getName())) {
                int n = OK;
                return n;
            }
            if (recurse) {
                if (!EFS.getStore((URI)project_uri).fetchInfo().exists()) {
                    System.err.println(HeadlessBuildMessages.HeadlessBuilder_Directory + String.valueOf(project_uri) + HeadlessBuildMessages.HeadlessBuilder_cant_be_found);
                    int n = ERROR;
                    return n;
                }
                IFileStore[] iFileStoreArray = EFS.getStore((URI)project_uri).childStores(0, (IProgressMonitor)monitor);
                int n = iFileStoreArray.length;
                int cwd = 0;
                while (cwd < n) {
                    int status;
                    IFileStore info = iFileStoreArray[cwd];
                    if (info.fetchInfo().isDirectory() && (status = this.importProject(info.toURI().toString(), recurse)) != OK) {
                        recurseStatus = status;
                    }
                    ++cwd;
                }
            }
            if (!(fstore = EFS.getStore((URI)project_uri).getChild(".project")).fetchInfo().exists()) {
                if (!recurse) {
                    System.err.println(HeadlessBuildMessages.HeadlessBuilder_project + String.valueOf(project_uri) + HeadlessBuildMessages.HeadlessBuilder_cant_be_found);
                    int n = ERROR;
                    return n;
                }
                int n = recurseStatus;
                return n;
            }
            in = fstore.openInputStream(0, (IProgressMonitor)monitor);
            IProjectDescription desc = root.getWorkspace().loadProjectDescription(in);
            IProject project = root.getProject(desc.getName());
            if (project.exists()) {
                if (URIUtil.equals((URI)project.getLocationURI(), (URI)project_uri)) {
                    project.open((IProgressMonitor)monitor);
                    int n = recurseStatus;
                    return n;
                }
                System.err.println(HeadlessBuildMessages.HeadlessBuilder_project + desc.getName() + HeadlessBuildMessages.HeadlessBuilder_already_exists_in_workspace);
                int n = ERROR;
                return n;
            }
            if (!URIUtil.equals((URI)org.eclipse.core.runtime.URIUtil.append((URI)ResourcesPlugin.getWorkspace().getRoot().getLocationURI(), (String)org.eclipse.core.runtime.URIUtil.lastSegment((URI)project_uri)), (URI)project_uri)) {
                desc.setLocationURI(project_uri);
            } else {
                project_uri = null;
            }
            if (!root.getWorkspace().validateProjectLocationURI(project, project_uri).equals(Status.OK_STATUS)) {
                System.err.println(HeadlessBuildMessages.HeadlessBuilder_URI + String.valueOf(project_uri) + HeadlessBuildMessages.HeadlessBuilder_is_not_valid_in_workspace);
                int n = ERROR;
                return n;
            }
            project.create(desc, (IProgressMonitor)monitor);
            project.open((IProgressMonitor)monitor);
            return recurseStatus;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int removeProject(String projURIStr, boolean recurse) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        PrintingProgressMonitor monitor = new PrintingProgressMonitor(true);
        InputStream in = null;
        int recurseStatus = OK;
        try {
            IFileStore fstore;
            URI project_uri = null;
            try {
                project_uri = URI.create(projURIStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (project_uri == null || project_uri.getScheme() == null) {
                IPath p = new Path(projURIStr).addTrailingSeparator();
                project_uri = URIUtil.toURI((IPath)p);
                if (project_uri.getScheme() == null) {
                    String cwd = System.getProperty("user.dir");
                    p = new Path(cwd).addTrailingSeparator();
                    p = p.append(projURIStr);
                    project_uri = URIUtil.toURI((IPath)p);
                }
                if (project_uri.getScheme() == null) {
                    System.err.println(HeadlessBuildMessages.HeadlessBuilder_invalid_uri + String.valueOf(project_uri));
                    int n = ERROR;
                    return n;
                }
            }
            if (SPECIAL_DIRS.contains(EFS.getStore((URI)project_uri).fetchInfo().getName())) {
                int n = OK;
                return n;
            }
            if (recurse) {
                if (!EFS.getStore((URI)project_uri).fetchInfo().exists()) {
                    System.err.println(HeadlessBuildMessages.HeadlessBuilder_Directory + String.valueOf(project_uri) + HeadlessBuildMessages.HeadlessBuilder_cant_be_found);
                    int n = ERROR;
                    return n;
                }
                IFileStore[] iFileStoreArray = EFS.getStore((URI)project_uri).childStores(0, (IProgressMonitor)monitor);
                int n = iFileStoreArray.length;
                int cwd = 0;
                while (cwd < n) {
                    int status;
                    IFileStore info = iFileStoreArray[cwd];
                    if (info.fetchInfo().isDirectory() && (status = this.removeProject(info.toURI().toString(), recurse)) != OK) {
                        recurseStatus = status;
                    }
                    ++cwd;
                }
            }
            if (!(fstore = EFS.getStore((URI)project_uri).getChild(".project")).fetchInfo().exists()) {
                if (!recurse) {
                    System.err.println(HeadlessBuildMessages.HeadlessBuilder_project + String.valueOf(project_uri) + HeadlessBuildMessages.HeadlessBuilder_cant_be_found);
                    int n = ERROR;
                    return n;
                }
                int n = recurseStatus;
                return n;
            }
            in = fstore.openInputStream(0, (IProgressMonitor)monitor);
            IProjectDescription desc = root.getWorkspace().loadProjectDescription(in);
            IProject project = root.getProject(desc.getName());
            if (!project.exists()) return recurseStatus;
            if (project.isOpen()) {
                project.close((IProgressMonitor)monitor);
            }
            project.delete(false, true, (IProgressMonitor)monitor);
            int n = recurseStatus;
            return n;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isProjectSuccesfullyBuild(IProject project) {
        try {
            String markerType;
            int findMaxProblemSeverity;
            Iterator<String> iterator = this.markerTypes.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while ((findMaxProblemSeverity = project.findMaxProblemSeverity(markerType = iterator.next(), true, 2)) < 2);
            return false;
        }
        catch (CoreException e) {
            ManagedBuilderCorePlugin.log(e);
            return false;
        }
    }

    protected void accumulateErrorMarkers(IProject project, List<String> allBuildErrors) {
        try {
            for (String markerType : this.markerTypes) {
                IMarker[] findMarkers;
                IMarker[] iMarkerArray = findMarkers = project.findMarkers(markerType, true, 2);
                int n = findMarkers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    int severity = marker.getAttribute("severity", 0);
                    if (severity >= 2) {
                        allBuildErrors.add(marker.toString());
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            ManagedBuilderCorePlugin.log(e);
        }
    }

    /*
     * Exception decompiling
     */
    public Object start(IApplicationContext context) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 13[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean checkInstanceLocation() {
        Location instanceLoc = Platform.getInstanceLocation();
        if (instanceLoc == null || !instanceLoc.isSet()) {
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_MustSpecifyWorkspace);
            return false;
        }
        try {
            if (!instanceLoc.lock()) {
                System.err.println(HeadlessBuildMessages.HeadlessBuilder_WorkspaceInUse);
                return false;
            }
            return true;
        }
        catch (IOException e) {
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_CouldntLockWorkspace);
            return false;
        }
    }

    public boolean getArguments(String[] args) {
        try {
            if (args == null || args.length == 0) {
                throw new Exception(HeadlessBuildMessages.HeadlessBuilder_no_arguments);
            }
            int i = 0;
            while (i < args.length) {
                if ("-help".equals(args[i])) {
                    throw new Exception(HeadlessBuildMessages.HeadlessBuilder_help_requested);
                }
                if ("-remove".equals(args[i])) {
                    this.projectsToRemove.add(args[++i]);
                } else if ("-removeAll".equals(args[i])) {
                    this.projectTreeToRemove.add(args[++i]);
                } else if ("-import".equals(args[i])) {
                    this.projectsToImport.add(args[++i]);
                } else if ("-importAll".equals(args[i])) {
                    this.projectTreeToImport.add(args[++i]);
                } else if ("-build".equals(args[i])) {
                    this.projectRegExToBuild.add(args[++i]);
                } else if ("-cleanBuild".equals(args[i])) {
                    this.projectRegExToClean.add(args[++i]);
                } else if ("-D".equals(args[i])) {
                    String macro = args[++i];
                    String macroVal = "";
                    if (macro.indexOf(61) != -1) {
                        macroVal = macro.substring(macro.indexOf(61) + 1);
                        macro = macro.substring(0, macro.indexOf(61));
                    }
                    HeadlessBuilderExternalSettingsProvider.additionalSettings.add((ICSettingEntry)CDataUtil.createCMacroEntry((String)macro, (String)macroVal, (int)0));
                } else if ("-I".equals(args[i])) {
                    HeadlessBuilderExternalSettingsProvider.additionalSettings.add((ICSettingEntry)CDataUtil.createCIncludePathEntry((String)args[++i], (int)0));
                } else if ("-include".equals(args[i])) {
                    HeadlessBuilderExternalSettingsProvider.additionalSettings.add((ICSettingEntry)CDataUtil.createCIncludeFileEntry((String)args[++i], (int)0));
                } else if ("-E".equals(args[i])) {
                    this.addEnvironmentVariable(args[++i], 1);
                } else if ("-Ea".equals(args[i])) {
                    this.addEnvironmentVariable(args[++i], 4);
                } else if ("-Ep".equals(args[i])) {
                    this.addEnvironmentVariable(args[++i], 3);
                } else if ("-Er".equals(args[i])) {
                    this.addEnvironmentVariable(args[++i], 2);
                } else if ("-T".equals(args[i])) {
                    toolId = args[++i];
                    option = args[++i];
                    this.addToolOption(toolId, option, 0);
                } else if ("-Ta".equals(args[i])) {
                    toolId = args[++i];
                    option = args[++i];
                    this.addToolOption(toolId, option, 1);
                } else if ("-Tp".equals(args[i])) {
                    toolId = args[++i];
                    option = args[++i];
                    this.addToolOption(toolId, option, 2);
                } else if ("-Tr".equals(args[i])) {
                    toolId = args[++i];
                    option = args[++i];
                    this.addToolOption(toolId, option, 3);
                } else if ("-no-indexer".equals(args[i])) {
                    this.disableIndexer = true;
                } else if ("-verbose".equals(args[i])) {
                    this.verboseProgressMonitor = true;
                } else if ("-markerType".equals(args[i])) {
                    this.addMarkerType(args[++i]);
                } else if ("-printErrorMarkers".equals(args[i])) {
                    this.printErrorMarkers = true;
                } else {
                    throw new Exception(HeadlessBuildMessages.HeadlessBuilder_unknown_argument + args[i]);
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_invalid_argument + Arrays.toString(args));
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_Error + e.getMessage());
            return false;
        }
        if (this.projectRegExToClean.contains("all") || this.projectRegExToClean.contains("*")) {
            this.cleanAll = true;
            this.buildAll = true;
            this.projectRegExToClean.remove("all");
            this.projectRegExToClean.remove("*");
        }
        if (this.projectRegExToBuild.contains("all") || this.projectRegExToBuild.contains("*")) {
            this.buildAll = true;
            this.projectRegExToBuild.remove("all");
            this.projectRegExToBuild.remove("*");
        }
        return true;
    }

    protected void addEnvironmentVariable(String string, int op) throws Exception {
        String[] parts = string.split("=", 2);
        String name = parts[0];
        String value = "";
        if (parts.length > 1) {
            value = parts[1];
        }
        EnvironmentVariableManager.fUserSupplier.createOverrideVariable(name, value, op, null);
    }

    protected void addToolOption(String toolId, String option, int operation) {
        String optionId = option;
        String value = "";
        if (option.indexOf(61) != -1) {
            value = option.substring(option.indexOf(61) + 1);
            optionId = option.substring(0, option.indexOf(61));
        }
        this.toolOptions.add(new ToolOption(toolId, optionId, value, operation));
    }

    protected void addMarkerType(String markerType) {
        this.markerTypesDefault = false;
        if ("all".equals(markerType)) {
            this.markerTypesAll = true;
        } else if ("cdt".equals(markerType)) {
            this.markerTypes.add("org.eclipse.cdt.core.problem");
        } else {
            this.markerTypes.add(markerType);
        }
    }

    protected void setToolOptions(IConfiguration configuration) throws BuildException {
        if (!this.savedToolOptions.containsKey(configuration.getId())) {
            this.savedToolOptions.put(configuration.getId(), new HashSet());
        }
        Set<SavedToolOption> savedToolOptionsSet = this.savedToolOptions.get(configuration.getId());
        for (ToolOption toolOption : this.toolOptions) {
            ITool[] tools;
            ITool[] iToolArray = tools = configuration.getToolsBySuperClassId(toolOption.toolId);
            int n = tools.length;
            int n2 = 0;
            while (n2 < n) {
                ITool tool = iToolArray[n2];
                IOption option = tool.getOptionBySuperClassId(toolOption.optionId);
                if (option != null) {
                    savedToolOptionsSet.add(new SavedToolOption(tool.getId(), option.getId(), option.getValue()));
                    switch (option.getValueType()) {
                        case 0: {
                            boolean booleanValue = (Boolean)option.getDefaultValue();
                            if (toolOption.operation != 3) {
                                booleanValue = Boolean.parseBoolean(toolOption.value);
                            }
                            ManagedBuildManager.setOption(configuration, (IHoldsOptions)tool, option, booleanValue);
                            break;
                        }
                        case -11: 
                        case -10: 
                        case -9: 
                        case -8: 
                        case -5: 
                        case -4: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: {
                            List<Object> listValue = new ArrayList<String>();
                            switch (toolOption.operation) {
                                case 1: {
                                    listValue.addAll((List)option.getValue());
                                    listValue.addAll(Arrays.asList(toolOption.value.split(",")));
                                    break;
                                }
                                case 2: {
                                    listValue.addAll(Arrays.asList(toolOption.value.split(",")));
                                    listValue.addAll((List)option.getValue());
                                    break;
                                }
                                case 3: {
                                    listValue = (List)option.getDefaultValue();
                                    break;
                                }
                                default: {
                                    listValue = Arrays.asList(toolOption.value.split(","));
                                }
                            }
                            ManagedBuildManager.setOption(configuration, (IHoldsOptions)tool, option, listValue == null ? new String[]{} : listValue.toArray(new String[listValue.size()]));
                            break;
                        }
                        default: {
                            Object stringValue = toolOption.value;
                            switch (toolOption.operation) {
                                case 1: {
                                    stringValue = String.valueOf(option.getValue()) + (String)stringValue;
                                    break;
                                }
                                case 2: {
                                    stringValue = (String)stringValue + String.valueOf(option.getValue());
                                    break;
                                }
                                case 3: {
                                    stringValue = (String)option.getDefaultValue();
                                }
                            }
                            ManagedBuildManager.setOption(configuration, (IHoldsOptions)tool, option, (String)stringValue);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    protected void resetToolOptions(IConfiguration configuration) throws BuildException {
        for (SavedToolOption toolOption : this.savedToolOptions.get(configuration.getId())) {
            IOption option = configuration.getTool(toolOption.toolId).getOptionById(toolOption.optionId);
            option.setValue(toolOption.value);
        }
    }

    public void stop() {
    }

    public static class PrintingProgressMonitor
    extends NullProgressMonitor {
        private boolean printSubtasks;
        private String last;

        public PrintingProgressMonitor(boolean printSubtasks) {
            this.printSubtasks = printSubtasks;
        }

        public void beginTask(String name, int totalWork) {
            if (name != null && name.length() > 0) {
                System.out.println(name);
            }
            this.last = name;
        }

        public void subTask(String name) {
            if (this.printSubtasks && name != null && name.length() > 0 && !Objects.equals(this.last, name)) {
                System.out.println(name);
            }
            this.last = name;
        }
    }

    protected static class SavedToolOption {
        final String toolId;
        final String optionId;
        final Object value;

        SavedToolOption(String toolId, String optionId, Object value) {
            this.toolId = toolId;
            this.optionId = optionId;
            this.value = value;
        }

        public int hashCode() {
            return this.toolId.hashCode() + this.optionId.hashCode();
        }

        public boolean equals(Object obj) {
            SavedToolOption option = (SavedToolOption)obj;
            return this.toolId.equals(option.toolId) && this.optionId.equals(option.optionId);
        }
    }

    protected static class ToolOption {
        public static final int REPLACE = 0;
        public static final int APPEND = 1;
        public static final int PREPEND = 2;
        public static final int REMOVE = 3;
        final String toolId;
        final String optionId;
        final String value;
        final int operation;

        ToolOption(String toolId, String optionId, String value, int operation) {
            this.toolId = toolId;
            this.optionId = optionId;
            this.value = value;
            this.operation = operation;
        }
    }
}

