/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.language.settings.providers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.AbstractExecutableExtensionBase;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableManager;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsBroadcastingProvider;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsStorage;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICFileDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICPathEntry;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;

public class MBSLanguageSettingsProvider
extends AbstractExecutableExtensionBase
implements ILanguageSettingsBroadcastingProvider {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<ICLanguageSettingEntry> getSettingEntries(ICConfigurationDescription cfgDescription, IResource rc, String languageId) {
        if (cfgDescription == null || rc == null) {
            return null;
        }
        IPath projectPath = rc.getProjectRelativePath();
        ICLanguageSetting[] languageSettings = null;
        if (rc instanceof IFile) {
            ICLanguageSetting ls = cfgDescription.getLanguageSettingForFile(projectPath, true);
            if (ls == null) return this.getSettingEntries(cfgDescription, (IResource)rc.getParent(), languageId);
            languageSettings = new ICLanguageSetting[]{ls};
        } else {
            ICResourceDescription rcDescription = cfgDescription.getResourceDescription(projectPath, false);
            languageSettings = this.getLanguageSettings(rcDescription);
        }
        ArrayList<ICLanguageSettingEntry> list = new ArrayList<ICLanguageSettingEntry>();
        if (languageSettings == null) return LanguageSettingsStorage.getPooledList(list);
        ICLanguageSetting[] iCLanguageSettingArray = languageSettings;
        int n = languageSettings.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            ICLanguageSetting langSetting = iCLanguageSettingArray[n2];
            if (langSetting != null && ((id = langSetting.getLanguageId()) == languageId || id != null && id.equals(languageId))) {
                int kindsBits = langSetting.getSupportedEntryKinds();
                int kind = 1;
                while (kind <= kindsBits) {
                    if ((kindsBits & kind) != 0) {
                        List additions = langSetting.getSettingEntriesList(kind);
                        for (ICLanguageSettingEntry entry : additions) {
                            String pathStr;
                            if (entry instanceof ICPathEntry && !new Path(pathStr = ((ICPathEntry)entry).getName()).isAbsolute()) {
                                ICdtVariableManager varManager = CCorePlugin.getDefault().getCdtVariableManager();
                                try {
                                    int flags;
                                    IStringVariableManager mngr;
                                    String projectRootedPath;
                                    ICLanguageSettingEntry projectRootedEntry;
                                    String location = varManager.resolveValue(pathStr, "", null, cfgDescription);
                                    if (!new Path(location).isAbsolute() && !list.contains(projectRootedEntry = (ICLanguageSettingEntry)CDataUtil.createEntry((int)kind, (String)(projectRootedPath = (mngr = VariablesPlugin.getDefault().getStringVariableManager()).generateVariableExpression("workspace_loc", rc.getProject().getName()) + "/" + pathStr), (String)projectRootedPath, null, (int)(flags = entry.getFlags() & 0xFFFFFFE7)))) {
                                        list.add(projectRootedEntry);
                                    }
                                }
                                catch (CdtVariableException e) {
                                    ManagedBuilderCorePlugin.log(e);
                                }
                            }
                            if (list.contains(entry)) continue;
                            list.add(entry);
                        }
                    }
                    kind <<= 1;
                }
            }
            ++n2;
        }
        return LanguageSettingsStorage.getPooledList(list);
    }

    private ICLanguageSetting[] getLanguageSettings(ICResourceDescription rcDescription) {
        ICLanguageSetting[] array = null;
        switch (rcDescription.getType()) {
            case 1: 
            case 2: 
            case 4: {
                ICFolderDescription foDes = (ICFolderDescription)rcDescription;
                array = foDes.getLanguageSettings();
                break;
            }
            case 8: {
                ICFileDescription fiDes = (ICFileDescription)rcDescription;
                ICLanguageSetting ls = fiDes.getLanguageSetting();
                if (ls == null) break;
                array = new ICLanguageSetting[]{ls};
            }
        }
        if (array == null) {
            array = new ICLanguageSetting[]{};
        }
        return array;
    }

    public LanguageSettingsStorage copyStorage() {
        class PretendStorage
        extends LanguageSettingsStorage {
            PretendStorage() {
            }

            public boolean isEmpty() {
                return false;
            }

            public LanguageSettingsStorage clone() throws CloneNotSupportedException {
                return this;
            }

            public boolean equals(Object obj) {
                return false;
            }
        }
        return new PretendStorage();
    }
}

