/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.providers.content.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentService;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObjectListener;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.providers.content.virtual.VirtualNode;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.virtual.IVirtualNode;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.loading.ILoadingService;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.loading.LoadingNode;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.providers.ServerExplorerManager;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.providers.content.layout.IServerExplorerLayoutProviderNav;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.providers.content.layout.hierar.ServerExplorerHierarchicalLayoutNav;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.providers.content.layout.vnode.ServerExplorerVirtualNodeLayoutNav;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.layout.IServerExplorerLayoutExtensionProvider;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.services.IServerExplorerContentService;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.services.IServerExplorerLayoutService;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.services.IServerExplorerNavigationService;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.services.IServerExplorerNodeResolutionService;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.util.TransientEObjectUtil;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.util.resources.ResourceLoader;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.navigator.CommonViewer;

public class ServerExplorerContentProviderNav
implements IServerExplorerContentService,
IServerExplorerNodeResolutionService,
IServerExplorerLayoutService,
IServerExplorerNavigationService,
ICatalogObjectListener,
ILoadingService {
    private static final ContainmentService containmentService = RDBCorePlugin.getDefault().getContainmentService();
    private static final ResourceLoader resourceLoader = ResourceLoader.INSTANCE;
    private static final String DESCRIPTION = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.DESCRIPTION");
    private IServerExplorerLayoutProviderNav layoutProvider = new ServerExplorerVirtualNodeLayoutNav(this);
    private CommonViewer viewer;
    private List layoutProvidersExtensionList = new LinkedList();

    public ServerExplorerContentProviderNav() {
        if (this.getClass().equals(ServerExplorerContentProviderNav.class)) {
            ServerExplorerManager.INSTANCE.setServerExplorerService(this);
        }
    }

    private CommonViewer getViewer() {
        return this.viewer;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof CommonViewer && this.viewer == null) {
            this.viewer = (CommonViewer)viewer;
            this.enableVirtualNodeLayout();
            RefreshManager.getInstance().AddListener(null, (ICatalogObjectListener)this);
        }
    }

    public void notifyChanged(final ICatalogObject dmElement, int eventType) {
        if (eventType == 0 && this.viewer != null) {
            if (this.viewer.getControl().isDisposed()) {
                RefreshManager.getInstance().removeListener(null, (ICatalogObjectListener)this);
            } else {
                this.viewer.getControl().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ServerExplorerContentProviderNav.this.viewer.refresh((Object)dmElement, true);
                    }
                });
            }
        }
    }

    public boolean isServerExplorerViewer() {
        return this.viewer != null;
    }

    public Object[] getChildren(Object parent) {
        return new ILoadingService.Loading().getChildren((AbstractTreeViewer)this.viewer, parent, this);
    }

    @Override
    public String getLoadingDescription() {
        return DESCRIPTION;
    }

    @Override
    public Object[] load(Object parentElement) {
        if (parentElement instanceof ConnectionInfo) {
            return new Object[]{((ConnectionInfo)parentElement).getSharedDatabase()};
        }
        if (parentElement instanceof VirtualNode && ((IVirtualNode)parentElement).hasChildren()) {
            return ((IVirtualNode)parentElement).getChildrenArray();
        }
        return this.layoutProvider.getChildren(parentElement);
    }

    public Object getParent(Object element) {
        if (this.isServerExplorerViewer()) {
            Object result = this.getViewer().testFindItem(element);
            Object object = result != null ? ((TreeItem)result).getParentItem().getData() : (result = element instanceof IVirtualNode ? ((IVirtualNode)element).getParent() : null);
            result = result != null ? result : (element instanceof EObject ? containmentService.getContainer((EObject)element) : null);
            return result;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IConnectionProfile) {
            return ((IConnectionProfile)element).getConnectionState() != 0;
        }
        return element instanceof ConnectionInfo && ((ConnectionInfo)element).getSharedDatabase() == null ? false : !(element instanceof LoadingNode);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        RefreshManager.getInstance().removeListener(null, (ICatalogObjectListener)this);
        if (this.getClass().equals(ServerExplorerContentProviderNav.class)) {
            ServerExplorerManager.INSTANCE.setServerExplorerService(null);
        }
    }

    private void loadChilds(CommonViewer viewer, Object parent) {
        viewer.expandToLevel(parent, 1);
        try {
            Job.getJobManager().join((Object)LoadingNode.LOADING_FAMILY, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (OperationCanceledException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private Object getVirtualNode(CommonViewer viewer, Object parent, String groupID) {
        if (parent != null) {
            if (parent instanceof IConnectionProfile) {
                return parent;
            }
            TreeItem[] items = this.getServerExplorerChildren(parent);
            if (items.length != 0) {
                int i = 0;
                int n = items.length;
                while (i < n) {
                    TreeItem child = items[i];
                    Object childNode = child.getData();
                    if (childNode instanceof IVirtualNode && ((IVirtualNode)childNode).getGroupID().equals(groupID)) {
                        return (IVirtualNode)child.getData();
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    public TreeItem[] getServerExplorerChildren(Object object) {
        TreeItem w = (TreeItem)this.getViewer().testFindItem(object);
        return w == null ? new TreeItem[]{} : w.getItems();
    }

    private Object getEObjectNode(CommonViewer viewer, Object parent, String name) {
        TreeItem[] items;
        if (parent != null && (items = this.getServerExplorerChildren(parent)).length != 0) {
            int i = 0;
            int n = items.length;
            while (i < n) {
                TreeItem child = items[i];
                Object childNode = child.getData();
                if (childNode instanceof ENamedElement && ((ENamedElement)childNode).getName().equals(name)) {
                    return childNode;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public void expandNode(EObject eObject) {
        try {
            this.expandNode(TransientEObjectUtil.getEObjectId(eObject));
        }
        catch (Exception exception) {}
    }

    @Override
    public void selectAndReveal(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object object : structuredSelection) {
                if (!(object instanceof EObject)) continue;
                this.expandNode((EObject)object);
            }
        }
        this.getViewer().setSelection(selection, true);
    }

    @Override
    public void expandNode(String pathToNavigate) {
        CommonViewer viewer = this.getViewer();
        try {
            Object node = this.getNode(pathToNavigate, viewer);
            if (node != null) {
                viewer.setSelection((ISelection)new StructuredSelection(node));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public EObject getEObjectNode(String pathToNavigate) {
        CommonViewer viewer = this.getViewer();
        Object node = this.getNode(pathToNavigate, viewer);
        if (node instanceof EObject) {
            return (EObject)node;
        }
        return null;
    }

    private Object getNode(String pathToNavigate, CommonViewer iViewer) {
        CommonViewer viewer = iViewer;
        Object parent1 = null;
        try {
            List path = TransientEObjectUtil.getPathFromID(pathToNavigate);
            Iterator pathIterator = path.iterator();
            parent1 = ProfileManager.getInstance().getProfileByName((String)pathIterator.next());
            Object parent2 = null;
            while (pathIterator.hasNext()) {
                String pathString = (String)pathIterator.next();
                TransientEObjectUtil.IGroup group = TransientEObjectUtil.getGroupInfo(pathString);
                String groupID = group.getGroupId();
                String elementName = group.getElementName();
                if (elementName == null) continue;
                parent2 = this.getVirtualNode(viewer, parent1, groupID);
                if (parent2 == null) {
                    this.loadChilds(viewer, parent1);
                    parent2 = this.getVirtualNode(viewer, parent1, groupID);
                    if (parent2 == null && parent1 instanceof IVirtualNode) {
                        Object[] children = ((IVirtualNode)parent1).getChildrenArray();
                        int i = 0;
                        int n = children.length;
                        while (i < n) {
                            Object parent4 = this.getVirtualNode(viewer, children[i], groupID);
                            if (parent4 != null) {
                                parent2 = parent4;
                                break;
                            }
                            ++i;
                        }
                    }
                } else {
                    this.loadChilds(viewer, parent2);
                    Object parent3 = this.getVirtualNode(viewer, parent2, groupID);
                    if (parent3 != null) {
                        parent2 = parent3;
                    }
                }
                parent1 = parent2;
                if (elementName != null && (parent2 = this.getEObjectNode(viewer, parent1, elementName)) == null) {
                    this.loadChilds(viewer, parent1);
                    parent2 = this.getEObjectNode(viewer, parent1, elementName);
                }
                parent1 = parent2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return parent1;
    }

    @Override
    public IServerExplorerLayoutService getServerExplorerLayoutService() {
        return this;
    }

    @Override
    public void refreshServerExplorer() {
    }

    @Override
    public void updateLayout() {
    }

    @Override
    public void refreshNode(final Object node) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ServerExplorerContentProviderNav.this.isServerExplorerViewer()) {
                    ServerExplorerContentProviderNav.this.viewer.refresh(node, true);
                }
            }
        });
    }

    @Override
    public void enableVirtualNodeLayout() {
        this.layoutProvider = new ServerExplorerVirtualNodeLayoutNav(this);
        Iterator iterator = this.layoutProvidersExtensionList.iterator();
        while (iterator.hasNext()) {
            ((IServerExplorerLayoutExtensionProvider)iterator.next()).enableLayout(IServerExplorerLayoutExtensionProvider.Layout.VNODE);
        }
    }

    @Override
    public void enableHierarchicalLayout() {
        this.layoutProvider = new ServerExplorerHierarchicalLayoutNav(this);
        Iterator iterator = this.layoutProvidersExtensionList.iterator();
        while (iterator.hasNext()) {
            ((IServerExplorerLayoutExtensionProvider)iterator.next()).enableLayout(IServerExplorerLayoutExtensionProvider.Layout.HIERARCHICAL);
        }
    }

    @Override
    public boolean isVirtualNodeLayoutSelected() {
        return this.layoutProvider instanceof ServerExplorerVirtualNodeLayoutNav;
    }

    @Override
    public boolean isHierarchicalLayoutSelected() {
        return this.layoutProvider instanceof ServerExplorerHierarchicalLayoutNav;
    }

    @Override
    public void expandNode(Object node, int depth) {
        while (Display.getDefault().readAndDispatch()) {
        }
        this.viewer.expandToLevel(node, depth);
    }

    @Override
    public void updateSelection(ISelection selection) {
        this.viewer.setSelection(selection, true);
    }

    public void init(Object oldInput, Object newInput) {
    }

    private void traverseChildrenForType(List objectsList, TreeItem[] items, Class type) {
        int i = 0;
        int n = items.length;
        while (i < n) {
            TreeItem item = items[i];
            if (item.getData() != null && type.isAssignableFrom(item.getData().getClass())) {
                objectsList.add(item.getData());
            }
            this.traverseChildrenForType(objectsList, item.getItems(), type);
            ++i;
        }
    }

    @Override
    public Object[] getDSEExplorerObjectsByType(IConnectionProfile profile, Class type) {
        ConnectionInfo connectionInfo;
        Database database;
        IManagedConnection managedConnection = profile.getManagedConnection("org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo");
        if (managedConnection != null && ((database = (connectionInfo = (ConnectionInfo)managedConnection.getConnection().getRawConnection()).getSharedDatabase()) != null || (database = connectionInfo.getCachedDatabase()) != null)) {
            return this.getDSEExplorerObjectsByType(database, type);
        }
        return new Object[0];
    }

    @Override
    public Object[] getDSEExplorerObjectsByType(Object parent, Class type) {
        ArrayList objectsList = new ArrayList();
        if (parent != null) {
            TreeItem[] items = this.getServerExplorerChildren(parent);
            this.traverseChildrenForType(objectsList, items, type);
        }
        return objectsList.toArray(new Object[objectsList.size()]);
    }
}

