/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.services.SQLService;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.SOEUIPlugin;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.util.ILogger;
import org.eclipse.datatools.sqltools.sqleditor.result.GroupSQLResultRunnable;

public class ScriptsExecutionRunnable
implements Runnable {
    private String _scripts;
    private DatabaseIdentifier _databaseIdentifier;
    private ILogger _log = SOEUIPlugin.getLogger(null);
    private IJobChangeListener _jobListener;
    private boolean _syncExec;
    private IProgressMonitor _monitor;
    private String _groupExecutionDspString = "Group execution";
    private String _consumerName = "Schema object editor";

    public ScriptsExecutionRunnable(String scripts, DatabaseIdentifier databaseIdentifier, IJobChangeListener listener, boolean syncExec, IProgressMonitor monitor) {
        this._scripts = scripts;
        this._databaseIdentifier = databaseIdentifier;
        this._jobListener = listener;
        this._syncExec = syncExec;
        this._monitor = monitor;
    }

    public ScriptsExecutionRunnable(String scripts, DatabaseIdentifier databaseIdentifier, IJobChangeListener listener, boolean syncExec, IProgressMonitor monitor, String groupExecutionDspString, String consumerName) {
        this._scripts = scripts;
        this._databaseIdentifier = databaseIdentifier;
        this._jobListener = listener;
        this._syncExec = syncExec;
        this._monitor = monitor;
        this._groupExecutionDspString = groupExecutionDspString;
        this._consumerName = consumerName;
    }

    @Override
    public void run() {
        try {
            SQLDevToolsConfiguration f = SQLToolsFacade.getConfigurationByProfileName((String)this._databaseIdentifier.getProfileName());
            String[] groups = new String[]{this._scripts};
            SQLService sqlService = f.getSQLService();
            if (sqlService != null) {
                groups = sqlService.splitSQL(this._scripts);
            }
            GroupSQLResultRunnable job = new GroupSQLResultRunnable(null, groups, null, null, this._databaseIdentifier, false, null, this._groupExecutionDspString, this._consumerName);
            if (this._jobListener != null) {
                job.addJobChangeListener(this._jobListener);
            }
            job.addJobChangeListener(new IJobChangeListener(){

                public void aboutToRun(IJobChangeEvent event) {
                }

                public void awake(IJobChangeEvent event) {
                }

                public void done(final IJobChangeEvent event) {
                    SOEUIPlugin.getActiveWorkbenchShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!event.getResult().isOK()) {
                                ScriptsExecutionRunnable.this._monitor.setCanceled(true);
                            }
                        }
                    });
                }

                public void running(IJobChangeEvent event) {
                }

                public void scheduled(IJobChangeEvent event) {
                }

                public void sleeping(IJobChangeEvent event) {
                }
            });
            job.setUser(true);
            job.schedule();
            if (this._syncExec) {
                job.join();
            }
        }
        catch (Exception ex) {
            this._log.error("ScriptsExecutionRunnable_error_execution", (Throwable)ex);
        }
    }
}

