/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ast.parser;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.ast.parser.ISourceParser;
import org.eclipse.dltk.ast.parser.ISourceParserConfigurator;
import org.eclipse.dltk.ast.parser.ISourceParserFactory;
import org.eclipse.dltk.core.DLTKContributedExtension;
import org.eclipse.dltk.core.DLTKContributionExtensionManager;
import org.eclipse.dltk.core.DLTKCore;

public class SourceParserManager
extends DLTKContributionExtensionManager {
    static final String SOURCE_PARSER_EXT_POINT = "org.eclipse.dltk.core.sourceParsers";
    static final String PARSER_CONTRIBUTION_TAG = "parserContribution";
    static final String PARSER_TAG = "parser";
    static final String PARSER_CONFIGURATOR_TAG = "parserConfigurator";
    static final String PARSER_CONFIGURATOR_CLASS = "class";
    private static SourceParserManager instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SourceParserManager getInstance() {
        if (instance != null) return instance;
        Class<SourceParserManager> clazz = SourceParserManager.class;
        synchronized (SourceParserManager.class) {
            if (instance != null) return instance;
            instance = new SourceParserManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public ISourceParser getSourceParserById(String id) {
        return ((SourceParserContribution)this.getContributionById(id)).createSourceParser(null);
    }

    @Override
    protected boolean isNatureContribution(IConfigurationElement main) {
        return PARSER_CONTRIBUTION_TAG.equals(main.getName());
    }

    @Override
    protected String getContributionElementName() {
        return PARSER_TAG;
    }

    @Override
    protected String getExtensionPoint() {
        return SOURCE_PARSER_EXT_POINT;
    }

    @Override
    protected boolean isValidContribution(Object object) {
        return object instanceof ISourceParserFactory;
    }

    @Override
    protected Object configureContribution(Object object, IConfigurationElement config) {
        return new SourceParserContribution((ISourceParserFactory)object, config);
    }

    public ISourceParser getSourceParser(IProject project, String natureId) {
        SourceParserContribution contribution = (SourceParserContribution)this.getSelectedContribution(project, natureId);
        if (contribution != null) {
            return contribution.createSourceParser(project);
        }
        return null;
    }

    static class SourceParserContribution
    extends DLTKContributedExtension {
        private final ISourceParserFactory factory;
        private final IConfigurationElement config;
        @Nullable
        final ISourceParserConfigurator[] configurators;

        SourceParserContribution(ISourceParserFactory factory, IConfigurationElement config) {
            this.factory = factory;
            this.config = config;
            this.setInitializationData(config, null, null);
            this.configurators = this.getId() != null ? SourceParserContribution.createConfigurators(this.getId()) : null;
        }

        ISourceParser createSourceParser(@Nullable IProject project) {
            ISourceParser parser = this.factory.createSourceParser();
            if (parser instanceof IExecutableExtension) {
                try {
                    ((IExecutableExtension)parser).setInitializationData(this.config, null, null);
                }
                catch (CoreException e) {
                    DLTKCore.error(e);
                }
            }
            if (this.configurators != null) {
                ISourceParserConfigurator[] iSourceParserConfiguratorArray = this.configurators;
                int n = this.configurators.length;
                int n2 = 0;
                while (n2 < n) {
                    ISourceParserConfigurator configurator = iSourceParserConfiguratorArray[n2];
                    configurator.configure(parser, project);
                    ++n2;
                }
            }
            return parser;
        }

        private static ISourceParserConfigurator[] createConfigurators(String parserId) {
            ArrayList<ISourceParserConfigurator> result = null;
            IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(SourceParserManager.SOURCE_PARSER_EXT_POINT);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (SourceParserManager.PARSER_CONFIGURATOR_TAG.equals(element.getName()) && parserId.equals(element.getAttribute("id"))) {
                    try {
                        Object configurator = element.createExecutableExtension(SourceParserManager.PARSER_CONFIGURATOR_CLASS);
                        if (configurator instanceof ISourceParserConfigurator) {
                            if (result == null) {
                                result = new ArrayList<ISourceParserConfigurator>();
                            }
                            result.add((ISourceParserConfigurator)configurator);
                        }
                    }
                    catch (CoreException e) {
                        DLTKCore.error(e);
                    }
                }
                ++n2;
            }
            return result != null ? result.toArray(new ISourceParserConfigurator[result.size()]) : null;
        }
    }
}

