/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.templates.core.processes;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.embedcdt.internal.templates.core.Activator;
import org.osgi.framework.Bundle;

public class SetPropertyToPluginResource
extends ProcessRunner {
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        String bundleId = args[0].getSimpleValue();
        String relativePath = args[1].getSimpleValue();
        String propertyName = args[2].getSimpleValue();
        Bundle bundle = Platform.getBundle((String)bundleId);
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(relativePath), null);
        if (url == null) {
            throw new ProcessFailureException(this.getProcessMessage(processId, 4, "Bundle resource not found " + bundle + " " + relativePath));
        }
        try {
            String location = FileLocator.resolve((URL)url).getPath();
            Map values = template.getValueStore();
            if (values.containsKey(propertyName)) {
                values.put(propertyName, location);
            } else {
                Activator.log((String)("Property " + propertyName + " not defined."));
            }
        }
        catch (IOException e) {
            throw new ProcessFailureException(this.getProcessMessage(processId, 4, "Cannot resolve url " + url));
        }
    }
}

