/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.ui.actions;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.explorer.CDOExplorerElement;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.ui.DeleteElementsDialog;
import org.eclipse.emf.cdo.internal.explorer.AbstractElement;
import org.eclipse.emf.cdo.lm.Baseline;
import org.eclipse.emf.cdo.lm.Module;
import org.eclipse.emf.cdo.lm.System;
import org.eclipse.emf.cdo.lm.internal.client.LMManager;
import org.eclipse.emf.cdo.lm.ui.actions.LMAction;
import org.eclipse.emf.cdo.lm.ui.bundle.OM;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPage;

public abstract class DeleteCheckoutsAction<CONTEXT extends CDOObject>
extends LMAction<CONTEXT> {
    private AbstractElement[] checkouts;
    private boolean deleteContents;

    private DeleteCheckoutsAction(IWorkbenchPage page, CONTEXT context, String contextTypeName) {
        super(page, "Delete Checkouts" + INTERACTIVE, "Delete the checkouts of the selected '" + contextTypeName.toLowerCase() + "'", OM.getImageDescriptor("icons/Delete.gif"), "Delete the checkouts of the selected '" + contextTypeName.toLowerCase() + "'.", null, context);
    }

    public boolean contributeIfNeeded(IMenuManager manager) {
        this.checkouts = this.collectCheckouts(this.getContext());
        if (this.checkouts.length != 0) {
            manager.add((IAction)this);
            return true;
        }
        return false;
    }

    @Override
    protected boolean isDialogNeeded() {
        return false;
    }

    @Override
    protected void fillDialogArea(LMAction.LMDialog dialog, Composite parent) {
    }

    @Override
    protected void preRun() throws Exception {
        DeleteElementsDialog dialog;
        if (this.checkouts == null) {
            this.checkouts = this.collectCheckouts(this.getContext());
        }
        if ((dialog = new DeleteElementsDialog(this.getShell(), this.checkouts)).open() == 0) {
            this.deleteContents = dialog.isDeleteContents();
        } else {
            this.cancel();
        }
    }

    private AbstractElement[] collectCheckouts(CONTEXT context) {
        ArrayList<AbstractElement> result = new ArrayList<AbstractElement>();
        String propertyName = this.getLMPropertyName();
        String propertyValue = this.getLMPropertyValue(context);
        CDOCheckout[] cDOCheckoutArray = CDOExplorerUtil.getCheckoutManager().getCheckouts();
        int n = cDOCheckoutArray.length;
        int n2 = 0;
        while (n2 < n) {
            String property;
            CDOCheckout checkout = cDOCheckoutArray[n2];
            Properties properties = LMManager.loadLMProperties((CDOExplorerElement)checkout);
            if (properties != null && Objects.equals(property = properties.getProperty(propertyName), propertyValue)) {
                result.add((AbstractElement)checkout);
            }
            ++n2;
        }
        return result.toArray(new AbstractElement[result.size()]);
    }

    protected abstract String getLMPropertyName();

    protected abstract String getLMPropertyValue(CONTEXT var1);

    @Override
    protected void doRun(CONTEXT context, IProgressMonitor monitor) throws Exception {
        AbstractElement[] abstractElementArray = this.checkouts;
        int n = this.checkouts.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractElement checkout = abstractElementArray[n2];
            checkout.delete(this.deleteContents);
            ++n2;
        }
    }

    public static final class OfBaseline
    extends DeleteCheckoutsAction<Baseline> {
        public OfBaseline(IWorkbenchPage page, Baseline baseline) {
            super(page, baseline, "baseline");
        }

        @Override
        protected String getLMPropertyName() {
            return "baselineID";
        }

        @Override
        protected String getLMPropertyValue(Baseline baseline) {
            return CDOExplorerUtil.getCDOIDString((CDOID)baseline.cdoID());
        }
    }

    public static final class OfModule
    extends DeleteCheckoutsAction<Module> {
        public OfModule(IWorkbenchPage page, Module module) {
            super(page, module, "module");
        }

        @Override
        protected String getLMPropertyName() {
            return "moduleName";
        }

        @Override
        protected String getLMPropertyValue(Module module) {
            return module.getName();
        }
    }

    public static final class OfSystem
    extends DeleteCheckoutsAction<System> {
        public OfSystem(IWorkbenchPage page, System system) {
            super(page, system, "system");
        }

        @Override
        protected String getLMPropertyName() {
            return "systemName";
        }

        @Override
        protected String getLMPropertyValue(System system) {
            return system.getName();
        }
    }
}

