/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.util.IPackageClosure;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public abstract class PackageClosure
implements IPackageClosure {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_MODEL, PackageClosure.class);

    protected PackageClosure() {
    }

    @Override
    public Set<EPackage> calculate(Collection<EPackage> ePackages) {
        if (ePackages.isEmpty()) {
            return EMPTY_CLOSURE;
        }
        HashSet<EPackage> visited = new HashSet<EPackage>();
        for (EPackage ePackage : ePackages) {
            this.doCollectContents(ePackage, visited);
        }
        return visited;
    }

    private void doCollectContents(EPackage ePackage, Set<EPackage> visited) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Package closure for " + ePackage.getNsURI());
        }
        this.handleEPackage(ePackage, visited);
        for (EPackage subPackage : ePackage.getESubpackages()) {
            this.doCollectContents(subPackage, visited);
        }
    }

    protected abstract void handleEPackage(EPackage var1, Set<EPackage> var2);
}

