/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.converter.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.converter.ConverterPlugin;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.swt.widgets.Display;

public class ConverterUtil {
    public static final int ACTION_DEFAULT = 0;
    public static final int ACTION_MESSAGE_NONE = 1;
    public static final int ACTION_MESSAGE_SET = 2;
    public static final int ACTION_MESSAGE_SET_TYPED = 4;
    public static final int ACTION_MESSAGE_SET_ERROR = 8;
    public static final int ACTION_DIALOG_NONE = 256;
    public static final int ACTION_DIALOG_SHOW_IF_HAS_CHILD = 512;
    public static final int ACTION_DIALOG_SHOW = 1024;
    public static final int ACTION_DIALOG_SHOW_ERROR = 2048;
    private static final int ACTION_MESSAGE_MASK = 15;
    private static final int ACTION_DIALOG_MASK = 3840;

    public static DecodedAction decodeAction(int actionCode) {
        DecodedAction decodedAction = new DecodedAction();
        decodedAction.message = actionCode & 0xF;
        decodedAction.message = 8 == (decodedAction.message & 8) ? 8 : (4 == (decodedAction.message & 4) ? 4 : (2 == (decodedAction.message & 2) ? 2 : (1 == (decodedAction.message & 1) ? 1 : 0)));
        decodedAction.dialog = actionCode & 0xF00;
        decodedAction.dialog = 2048 == (decodedAction.dialog & 0x800) ? 2048 : (1024 == (decodedAction.dialog & 0x400) ? 1024 : (512 == (decodedAction.dialog & 0x200) ? 512 : (256 == (decodedAction.dialog & 0x100) ? 256 : 0)));
        return decodedAction;
    }

    public static int computeActionCode(Diagnostic diagnostic) {
        if ("org.eclipse.emf.converter".equals(diagnostic.getSource())) {
            int actionCode = diagnostic.getCode();
            for (Diagnostic child : diagnostic.getChildren()) {
                actionCode |= ConverterUtil.computeActionCode(child);
            }
            return actionCode;
        }
        return 0;
    }

    public static Diagnostic createDiagnostic(Diagnostic baseDiagnostic, String source, int code) {
        BasicDiagnostic basicDiagnostic = new BasicDiagnostic(baseDiagnostic.getSeverity(), source, code, baseDiagnostic.getMessage(), baseDiagnostic.getData().toArray());
        basicDiagnostic.addAll(baseDiagnostic);
        return basicDiagnostic;
    }

    public static Diagnostic mergeDiagnostic(Diagnostic baseDiagnostic, Diagnostic diagnosticToBeMerged) {
        if (diagnosticToBeMerged == null) {
            return baseDiagnostic;
        }
        if (baseDiagnostic == null) {
            return diagnosticToBeMerged;
        }
        if (baseDiagnostic instanceof DiagnosticChain) {
            ((DiagnosticChain)baseDiagnostic).merge(diagnosticToBeMerged);
            return baseDiagnostic;
        }
        BasicDiagnostic basicDiagnostic = new BasicDiagnostic(baseDiagnostic.getSeverity(), baseDiagnostic.getSource(), baseDiagnostic.getCode(), baseDiagnostic.getMessage(), baseDiagnostic.getData().toArray());
        basicDiagnostic.addAll(baseDiagnostic);
        basicDiagnostic.add(diagnosticToBeMerged);
        return basicDiagnostic;
    }

    public static Diagnostic createErrorDiagnostic(Throwable throwable, boolean showErrorDialog) {
        Diagnostic diagnostic = BasicDiagnostic.toDiagnostic((Throwable)throwable);
        if (showErrorDialog) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "org.eclipse.emf.converter", 2048, ConverterPlugin.INSTANCE.getString("_UI_GenericExceptionDialog_message"), new Object[]{throwable});
            basicDiagnostic.add(diagnostic);
            diagnostic = basicDiagnostic;
        } else {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "org.eclipse.emf.converter", 0, ConverterPlugin.INSTANCE.getString("_UI_GenericException_message", new Object[]{diagnostic.getMessage()}), new Object[]{throwable});
            basicDiagnostic.addAll(diagnostic);
            diagnostic = basicDiagnostic;
        }
        return diagnostic;
    }

    public static ResourceSet createResourceSet() {
        ResourceSetImpl result = new ResourceSetImpl();
        result.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)true));
        return result;
    }

    public static List<EPackage> computeRequiredPackages(EPackage ePackage) {
        EPackageList referencedEPackages = new EPackageList();
        TreeIterator j = ePackage.eAllContents();
        while (j.hasNext()) {
            EObject eObject = (EObject)j.next();
            for (Object o : eObject.eCrossReferences()) {
                if (!(o instanceof EClassifier)) continue;
                EClassifier eClassifier = (EClassifier)o;
                referencedEPackages.add(eClassifier.getEPackage());
            }
        }
        referencedEPackages.remove(ePackage);
        Iterator i = referencedEPackages.iterator();
        while (i.hasNext()) {
            EPackage referencedEPackage = (EPackage)i.next();
            if (!referencedEPackage.getNsURI().equals(ePackage.getNsURI())) continue;
            i.remove();
        }
        return referencedEPackages.isEmpty() ? Collections.emptyList() : referencedEPackages;
    }

    public static String getQualifiedName(EPackage ePackage) {
        if (ePackage == null) {
            return null;
        }
        StringBuffer label = new StringBuffer(ePackage.getName());
        EPackage parentEPackage = ePackage.getESuperPackage();
        while (parentEPackage != null) {
            label.insert(0, ".").insert(0, parentEPackage.getName());
            parentEPackage = parentEPackage.getESuperPackage();
        }
        return label.toString();
    }

    public static class DecodedAction {
        public int message;
        public int dialog;
    }

    public static class EPackageList
    extends UniqueEList.FastCompare<EPackage> {
        private static final long serialVersionUID = 1L;

        public EPackageList() {
        }

        public EPackageList(Collection<? extends EPackage> collection) {
            super(collection);
        }

        public EPackageList(int initialCapacity) {
            super(initialCapacity);
        }

        protected Object[] newData(int capacity) {
            return new EPackage[capacity];
        }
    }

    public static class GenPackageList
    extends UniqueEList.FastCompare<GenPackage> {
        private static final long serialVersionUID = 1L;

        public GenPackageList() {
        }

        public GenPackageList(Collection<? extends GenPackage> collection) {
            super(collection);
        }

        public GenPackageList(int initialCapacity) {
            super(initialCapacity);
        }

        protected Object[] newData(int capacity) {
            return new GenPackage[capacity];
        }
    }

    public static class ShellFinder {
        public static Object getActiveShell() {
            if (Platform.getBundle((String)"org.eclipse.swt") != null) {
                try {
                    return Display.getCurrent().getActiveShell();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static class WorkspaceResourceValidator {
        public static String validate(List<Resource> emfResources) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot workspaceRoot = workspace.getRoot();
            ArrayList<IResource> workspaceFiles = new ArrayList<IResource>(emfResources.size());
            ArrayList<File> externalFiles = new ArrayList<File>(emfResources.size());
            for (Resource resource : emfResources) {
                String path;
                IResource workspaceResource;
                URI uri = resource.getURI().trimFragment();
                if (uri.isFile()) {
                    File file = new File(uri.toFileString());
                    if (!file.isFile() || file.canWrite()) continue;
                    externalFiles.add(file);
                    continue;
                }
                if (!uri.isPlatformResource() || (workspaceResource = workspaceRoot.findMember((IPath)new Path(path = uri.toPlatformString(true)))) == null || workspaceResource.getType() != 1 || !workspaceResource.getResourceAttributes().isReadOnly()) continue;
                workspaceFiles.add(workspaceResource);
            }
            StringBuffer readOnlyFiles = new StringBuffer();
            if (!workspaceFiles.isEmpty()) {
                IFile[] files;
                Object context = null;
                if (Platform.getBundle((String)"org.eclipse.swt") != null) {
                    context = ShellFinder.getActiveShell();
                }
                if (!workspace.validateEdit(files = workspaceFiles.toArray(new IFile[workspaceFiles.size()]), context).isOK()) {
                    int i = 0;
                    while (i < files.length) {
                        if (files[i].isReadOnly()) {
                            readOnlyFiles.append(", ").append(files[i].getFullPath().toString());
                        }
                        ++i;
                    }
                }
            }
            if (!externalFiles.isEmpty()) {
                for (File file : externalFiles) {
                    readOnlyFiles.append(", ").append(file.getAbsolutePath());
                }
            }
            return readOnlyFiles.length() == 0 ? null : readOnlyFiles.deleteCharAt(0).deleteCharAt(0).toString();
        }
    }
}

